/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.credentials;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.slaves.WorkspaceList;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialContext;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialFactory;
import org.jenkinsci.plugins.docker.commons.impl.RegistryKeyMaterialFactory;

public final class DockerRegistryToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String email;
    private final String token;
    private static boolean USE_CUSTOM_LOGIN = Boolean.getBoolean(DockerRegistryToken.class.getName() + ".USE_CUSTOM_LOGIN");

    public DockerRegistryToken(String email, String token) {
        this.email = email;
        this.token = token;
    }

    public String getEmail() {
        return this.email;
    }

    public String getToken() {
        return this.token;
    }

    @Deprecated
    public KeyMaterialFactory newKeyMaterialFactory(URL endpoint, @Nonnull VirtualChannel target) throws InterruptedException, IOException {
        return this.newKeyMaterialFactory(endpoint, target, null, TaskListener.NULL);
    }

    @Deprecated
    public KeyMaterialFactory newKeyMaterialFactory(@Nonnull URL endpoint, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener, @Nonnull String dockerExecutable) throws InterruptedException, IOException {
        return this.newKeyMaterialFactory(endpoint, workspace, launcher, new EnvVars(), listener, dockerExecutable);
    }

    public KeyMaterialFactory newKeyMaterialFactory(@Nonnull URL endpoint, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull EnvVars env, @Nonnull TaskListener listener, @Nonnull String dockerExecutable) throws InterruptedException, IOException {
        if (!USE_CUSTOM_LOGIN) {
            try {
                String usernameColonPassword = new String(Base64.getDecoder().decode(this.token), StandardCharsets.UTF_8);
                int colon = usernameColonPassword.indexOf(58);
                if (colon > 0) {
                    return new RegistryKeyMaterialFactory(usernameColonPassword.substring(0, colon), usernameColonPassword.substring(colon + 1), endpoint, launcher, env, listener, dockerExecutable).contextualize(new KeyMaterialContext(WorkspaceList.tempDir((FilePath)workspace)));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            listener.getLogger().println("Warning: authentication token does not look like a username:password; falling back to direct manipulation of Docker configuration files");
        }
        return this.newKeyMaterialFactory(endpoint, workspace.getChannel(), launcher, listener);
    }

    @Deprecated
    public KeyMaterialFactory newKeyMaterialFactory(final @Nonnull URL endpoint, @Nonnull VirtualChannel target, @CheckForNull Launcher launcher, final @Nonnull TaskListener listener) throws InterruptedException, IOException {
        target.call((Callable)new MasterToSlaveCallable<Void, IOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void call() throws IOException {
                Class<DockerRegistryToken> clazz = DockerRegistryToken.class;
                synchronized (DockerRegistryToken.class) {
                    JSONObject auths;
                    JSONObject json;
                    File config = new File(System.getProperty("user.home"), ".docker/config.json");
                    if (config.exists()) {
                        json = JSONObject.fromObject((Object)FileUtils.readFileToString((File)config, (String)"UTF-8"));
                        auths = json.getJSONObject("auths");
                    } else {
                        config = new File(System.getProperty("user.home"), ".dockercfg");
                        auths = config.exists() ? (json = JSONObject.fromObject((Object)FileUtils.readFileToString((File)config, (String)"UTF-8"))) : (json = new JSONObject());
                    }
                    auths.put(endpoint.toString(), (Object)new JSONObject().accumulate("auth", (Object)DockerRegistryToken.this.getToken()).accumulate("email", (Object)DockerRegistryToken.this.getEmail()));
                    FileUtils.writeStringToFile((File)config, (String)json.toString(2), (String)"UTF-8");
                    listener.getLogger().println("Wrote authentication to " + config);
                    // ** MonitorExit[var3_1] (shouldn't be in output)
                    return null;
                }
            }
        });
        return KeyMaterialFactory.NULL;
    }
}

