/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.displayurlapi;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.jenkinsci.plugins.displayurlapi.DisplayURLContext;

public abstract class DisplayURLDecorator
implements ExtensionPoint {
    @NonNull
    protected abstract Map<String, String> parameters(@NonNull DisplayURLContext var1);

    @NonNull
    public static String decorate(@NonNull DisplayURLContext context, @NonNull String url) {
        ExtensionList extensionList = ExtensionList.lookup(DisplayURLDecorator.class);
        if (extensionList.isEmpty()) {
            return url;
        }
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        for (Object decorator : extensionList.reverseView()) {
            parameters.putAll(DisplayURLDecorator.fixNull(((DisplayURLDecorator)decorator).parameters(context)));
        }
        if (parameters.isEmpty()) {
            return url;
        }
        TreeMap<String, String> encodedParameters = new TreeMap<String, String>();
        for (Map.Entry entry : parameters.entrySet()) {
            encodedParameters.put(DisplayURLDecorator.encode((String)entry.getKey()), entry.getValue() == null ? null : DisplayURLDecorator.encode((String)entry.getValue()));
        }
        StringBuilder result = new StringBuilder(2083);
        int n = 63;
        int queryStart = url.indexOf(n);
        if (queryStart == -1) {
            result.append(url);
        } else {
            result.append(url, 0, queryStart);
            for (String pair : url.substring(queryStart + 1).split("&")) {
                int n2;
                int index = pair.indexOf(61);
                if (index == -1 && encodedParameters.containsKey(pair) || index > 0 && encodedParameters.containsKey(pair.substring(0, index))) continue;
                result.append((char)n2);
                result.append(pair);
                n2 = 38;
            }
        }
        for (Map.Entry p : encodedParameters.entrySet()) {
            int n3;
            result.append((char)n3).append((String)p.getKey());
            if (p.getValue() != null) {
                result.append('=').append((String)p.getValue());
            }
            n3 = 38;
        }
        return result.toString();
    }

    @NonNull
    private static <K, V> Map<K, V> fixNull(@CheckForNull Map<K, V> map) {
        return map == null ? Collections.emptyMap() : map;
    }

    private static String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("UTF-8 encoding is mandated by the JLS", e);
        }
    }
}

