/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.displayurlapi.actions;

import com.google.common.annotations.VisibleForTesting;
import hudson.ExtensionList;
import hudson.model.Action;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.displayurlapi.ClassicDisplayURLProvider;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.displayurlapi.user.PreferredProviderUserProperty;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class AbstractDisplayAction
implements Action {
    public static final String URL_NAME = "display";

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public final Object doRedirect(StaplerRequest req, StaplerResponse rsp) throws IOException {
        DisplayURLProvider provider = this.lookupProvider(req);
        rsp.sendRedirect(302, this.getRedirectURL(provider));
        return null;
    }

    protected abstract String getRedirectURL(DisplayURLProvider var1);

    DisplayURLProvider lookupProvider(StaplerRequest req) {
        ExtensionList<DisplayURLProvider> providers;
        DisplayURLProvider provider;
        String providerName = req.getParameter("provider");
        if (StringUtils.isNotEmpty((String)providerName) && (provider = (DisplayURLProvider)(providers = DisplayURLProvider.all()).stream().filter(Objects::nonNull).filter(displayURLProvider -> providerName.equals(displayURLProvider.getName())).findFirst().orElse(null)) != null) {
            return provider;
        }
        return this.lookupProvider();
    }

    DisplayURLProvider lookupProvider() {
        PreferredProviderUserProperty prefProperty = this.getUserPreferredProviderProperty();
        if (prefProperty != null && prefProperty.getConfiguredProvider() != null) {
            return prefProperty.getConfiguredProvider();
        }
        DisplayURLProvider displayURLProvider = DisplayURLProvider.getPreferredProvider();
        if (displayURLProvider == null) {
            ExtensionList<DisplayURLProvider> all = DisplayURLProvider.all();
            displayURLProvider = all.stream().filter(((Predicate<DisplayURLProvider>)ClassicDisplayURLProvider.class::isInstance).negate()).findFirst().orElse(DisplayURLProvider.getDefault());
        }
        return displayURLProvider;
    }

    @Deprecated
    @VisibleForTesting
    protected PreferredProviderUserProperty getUserPreferredProviderProperty() {
        return DisplayURLProvider.getUserPreferredProviderProperty();
    }
}

