/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.displayurlapi;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import java.io.Closeable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;

public class DisplayURLContext
implements Closeable {
    private static final String OUR_PLUGIN_NAME = "display-url-api";
    private static ThreadLocal<Stack<DisplayURLContext>> context = new ThreadLocal();
    private static final Cache<String, Optional<PluginWrapper>> CACHE = CacheBuilder.newBuilder().maximumSize((long)Integer.getInteger(DisplayURLContext.class.getName() + ".cache.size", 1000).intValue()).expireAfterAccess((long)Integer.getInteger(DisplayURLContext.class.getName() + ".cache.ttl", 300000).intValue(), TimeUnit.MILLISECONDS).build();
    private static Set<String> ourPluginClassNames = new HashSet<String>(Arrays.asList(DisplayURLContext.class.getName(), DisplayURLProvider.class.getName(), DisplayURLProvider.DisplayURLProviderImpl.class.getName()));
    private final DisplayURLContext parent;
    @CheckForNull
    private Queue.Task task;
    @CheckForNull
    private Queue.Executable executable;
    @CheckForNull
    private Job<?, ?> job;
    @CheckForNull
    private Run<?, ?> run;
    @CheckForNull
    private PluginWrapper plugin;
    @CheckForNull
    private Map<String, String> attributes;

    private DisplayURLContext(DisplayURLContext parent) {
        this.parent = parent;
    }

    private void guessPlugin() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        PluginManager manager = Jenkins.get().getPluginManager();
        ClassLoader loader = manager.uberClassLoader;
        for (StackTraceElement frame : stack) {
            String cname = frame.getClassName();
            if (ourPluginClassNames.contains(cname)) continue;
            Optional wrapper = (Optional)CACHE.getIfPresent((Object)cname);
            if (wrapper != null) {
                wrapper.ifPresent(pluginWrapper -> {
                    this.plugin = pluginWrapper;
                });
                continue;
            }
            try {
                Class<?> clazz = loader.loadClass(cname);
                PluginWrapper pluginWrapper2 = manager.whichPlugin(clazz);
                if (pluginWrapper2 != null && !OUR_PLUGIN_NAME.equals(pluginWrapper2.getShortName())) {
                    this.plugin = pluginWrapper2;
                    CACHE.put((Object)cname, Optional.of(pluginWrapper2));
                    break;
                }
                CACHE.put((Object)cname, Optional.empty());
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    @NonNull
    public static DisplayURLContext open(boolean guessPlugin) {
        Stack<DisplayURLContext> stack = context.get();
        if (stack == null) {
            stack = new Stack();
            context.set(stack);
        }
        DisplayURLContext context = new DisplayURLContext(stack.isEmpty() ? null : stack.peek());
        if (stack.isEmpty() && guessPlugin) {
            context.guessPlugin();
        }
        stack.push(context);
        return context;
    }

    @NonNull
    public static DisplayURLContext open() {
        return DisplayURLContext.open(true);
    }

    @NonNull
    public DisplayURLContext task(@CheckForNull Queue.Task task) {
        this.task = task;
        if (task instanceof Job) {
            this.job = (Job)task;
        }
        return this;
    }

    @NonNull
    public DisplayURLContext executable(@CheckForNull Queue.Executable executable) {
        this.executable = executable;
        if (executable != null) {
            this.task = executable.getParent().getOwnerTask();
        }
        if (executable instanceof Run) {
            this.run = (Run)executable;
            this.job = ((Run)executable).getParent();
        }
        return this;
    }

    @NonNull
    public DisplayURLContext job(@CheckForNull Job<?, ?> job) {
        this.job = job;
        if (job instanceof Queue.Task) {
            this.task = (Queue.Task)job;
        }
        return this;
    }

    @NonNull
    public DisplayURLContext run(@CheckForNull Run<?, ?> run) {
        this.run = run;
        if (run != null) {
            if (run instanceof Queue.Executable) {
                this.executable = (Queue.Executable)run;
            }
            this.job(run.getParent());
        }
        return this;
    }

    @NonNull
    public DisplayURLContext plugin(@CheckForNull PluginWrapper plugin) {
        this.plugin = plugin;
        return this;
    }

    @NonNull
    public DisplayURLContext attribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(name, value);
        return this;
    }

    @CheckForNull
    public Queue.Task task() {
        if (this.task == null && this.parent != null) {
            return this.parent.task();
        }
        return this.task;
    }

    @CheckForNull
    public Queue.Executable executable() {
        if (this.executable == null && this.parent != null) {
            return this.parent.executable();
        }
        return this.executable;
    }

    @CheckForNull
    public Job<?, ?> job() {
        if (this.job == null && this.parent != null) {
            return this.parent.job();
        }
        return this.job;
    }

    @CheckForNull
    public Run<?, ?> run() {
        if (this.run == null && this.parent != null) {
            return this.parent.run();
        }
        return this.run;
    }

    @CheckForNull
    public PluginWrapper plugin() {
        if (this.plugin == null && this.parent != null) {
            return this.parent.plugin();
        }
        return this.plugin;
    }

    @CheckForNull
    public String attribute(String name) {
        if (!(this.attributes != null && this.attributes.containsKey(name) || this.parent == null)) {
            return this.parent.attribute(name);
        }
        return this.attributes == null ? null : this.attributes.get(name);
    }

    @Override
    public void close() {
        Stack<DisplayURLContext> stack = context.get();
        if (stack != null) {
            stack.pop();
            if (stack.isEmpty()) {
                context.remove();
            }
        }
    }
}

