/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.displayurlapi;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.Job;
import hudson.model.Run;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.displayurlapi.ClassicDisplayURLProvider;
import org.jenkinsci.plugins.displayurlapi.DisplayURLContext;
import org.jenkinsci.plugins.displayurlapi.DisplayURLDecorator;

public abstract class DisplayURLProvider
implements ExtensionPoint {
    private static final String JENKINS_DISPLAYURL_PROVIDER_ENV = "JENKINS_DISPLAYURL_PROVIDER";
    private static final String JENKINS_DISPLAYURL_PROVIDER_PROP = "jenkins.displayurl.provider";

    public static DisplayURLProvider get() {
        return DisplayURLProviderImpl.INSTANCE;
    }

    public static ExtensionList<DisplayURLProvider> all() {
        return ExtensionList.lookup(DisplayURLProvider.class);
    }

    public static DisplayURLProvider getDefault() {
        DisplayURLProvider defaultProvider = DisplayURLProvider.getPreferredProvider();
        if (defaultProvider == null) {
            defaultProvider = (DisplayURLProvider)ExtensionList.lookup(DisplayURLProvider.class).get(ClassicDisplayURLProvider.class);
        }
        return defaultProvider;
    }

    @NonNull
    public String getRoot() {
        String root = Jenkins.getInstance().getRootUrl();
        if (root == null) {
            root = "http://unconfigured-jenkins-location/";
        }
        return Util.encode((String)root);
    }

    @NonNull
    public String getDisplayName() {
        return this.getClass().getSimpleName();
    }

    @NonNull
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @NonNull
    public abstract String getRunURL(Run<?, ?> var1);

    @NonNull
    public abstract String getChangesURL(Run<?, ?> var1);

    @NonNull
    public abstract String getJobURL(Job<?, ?> var1);

    private static String findClass() {
        String clazz = System.getenv(JENKINS_DISPLAYURL_PROVIDER_ENV);
        if (StringUtils.isEmpty((String)clazz)) {
            clazz = System.getProperty(JENKINS_DISPLAYURL_PROVIDER_PROP);
        }
        return clazz;
    }

    @Nullable
    public static DisplayURLProvider getPreferredProvider() {
        String clazz = DisplayURLProvider.findClass();
        if (StringUtils.isNotEmpty((String)clazz)) {
            return (DisplayURLProvider)ExtensionList.lookup(DisplayURLProvider.class).getDynamic(clazz);
        }
        return null;
    }

    static class DisplayURLProviderImpl
    extends ClassicDisplayURLProvider {
        static final DisplayURLProvider INSTANCE = new DisplayURLProviderImpl();
        static final String DISPLAY_POSTFIX = "display/redirect";

        DisplayURLProviderImpl() {
        }

        @Override
        @NonNull
        public String getRunURL(Run<?, ?> run) {
            try (DisplayURLContext ctx = DisplayURLContext.open();){
                if (ctx.run() == null) {
                    ctx.run(run);
                }
                String string = DisplayURLDecorator.decorate(ctx, super.getRunURL(run) + DISPLAY_POSTFIX);
                return string;
            }
        }

        @Override
        @NonNull
        public String getChangesURL(Run<?, ?> run) {
            try (DisplayURLContext ctx = DisplayURLContext.open();){
                if (ctx.run() == null) {
                    ctx.run(run);
                }
                String string = DisplayURLDecorator.decorate(ctx, super.getRunURL(run) + DISPLAY_POSTFIX + "?page=changes");
                return string;
            }
        }

        @Override
        @NonNull
        public String getJobURL(Job<?, ?> job) {
            try (DisplayURLContext ctx = DisplayURLContext.open();){
                if (ctx.job() == null) {
                    ctx.job(job);
                }
                String string = DisplayURLDecorator.decorate(ctx, super.getJobURL(job) + DISPLAY_POSTFIX);
                return string;
            }
        }
    }
}

