/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.displayurlapi.user;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import java.util.List;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.displayurlapi.user.PreferredProviderUserPropertyDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class PreferredProviderUserProperty
extends UserProperty {
    @Extension
    public static final UserPropertyDescriptor DESCRIPTOR = new PreferredProviderUserPropertyDescriptor();
    @Nullable
    private String providerId;

    @DataBoundConstructor
    public PreferredProviderUserProperty(@Nullable String providerId) {
        this.providerId = providerId;
    }

    public ProviderOption getProvider() {
        DisplayURLProvider provider = this.getConfiguredProvider();
        return provider == null ? ProviderOption.DEFAULT_OPTION : new ProviderOption(provider.getClass().getName(), provider.getDisplayName());
    }

    public DisplayURLProvider getConfiguredProvider() {
        return (DisplayURLProvider)Iterables.find(DisplayURLProvider.all(), (Predicate)new Predicate<DisplayURLProvider>(){

            public boolean apply(DisplayURLProvider input) {
                return input.getClass().getName().equals(PreferredProviderUserProperty.this.providerId);
            }
        }, null);
    }

    public List<ProviderOption> getAll() {
        Iterable options = Iterables.transform(DisplayURLProvider.all(), (Function)new Function<DisplayURLProvider, ProviderOption>(){

            public ProviderOption apply(DisplayURLProvider input) {
                return new ProviderOption(input.getClass().getName(), input.getDisplayName());
            }
        });
        return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Lists.newArrayList((Object[])new ProviderOption[]{ProviderOption.DEFAULT_OPTION}), (Iterable)options));
    }

    public boolean isSelected(String providerId) {
        return this.getProvider().getId().equals(providerId);
    }

    public static class ProviderOption {
        public static final ProviderOption DEFAULT_OPTION = new ProviderOption("default", "Default");
        private final String id;
        private final String name;

        public ProviderOption(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

