/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.displayurlapi.actions;

import com.google.common.collect.ImmutableList;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import java.util.Collection;
import javax.annotation.Nonnull;
import jenkins.model.TransientActionFactory;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.displayurlapi.actions.AbstractDisplayAction;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class RunDisplayAction
extends AbstractDisplayAction {
    private final Run run;

    protected RunDisplayAction(Run run) {
        this.run = run;
    }

    @Override
    protected String getRedirectURL(DisplayURLProvider provider) {
        StaplerRequest req = Stapler.getCurrentRequest();
        String page = req.getParameter("page");
        String url = "changes".equals(page) ? provider.getChangesURL(this.run) : provider.getRunURL(this.run);
        return url;
    }

    @Extension
    public static class TransientActionFactoryImpl
    extends TransientActionFactory {
        public Class type() {
            return Run.class;
        }

        @Nonnull
        public Collection<? extends Action> createFor(@Nonnull Object target) {
            return ImmutableList.of((Object)new RunDisplayAction((Run)target));
        }
    }
}

