/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.displayurlapi.actions;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import hudson.model.Action;
import hudson.model.User;
import java.io.IOException;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.displayurlapi.ClassicDisplayURLProvider;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.displayurlapi.user.PreferredProviderUserProperty;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class AbstractDisplayAction
implements Action {
    public static final String URL_NAME = "display";

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public final Object doRedirect(StaplerRequest req, StaplerResponse rsp) throws IOException {
        DisplayURLProvider provider = this.lookupProvider(req);
        rsp.sendRedirect(302, this.getRedirectURL(provider));
        return null;
    }

    protected abstract String getRedirectURL(DisplayURLProvider var1);

    DisplayURLProvider lookupProvider(StaplerRequest req) {
        Iterable<DisplayURLProvider> providers;
        Iterable filtered;
        DisplayURLProvider provider;
        final String providerName = req.getParameter("provider");
        if (providerName != null && !providerName.isEmpty() && (provider = (DisplayURLProvider)Iterables.getFirst((Iterable)(filtered = Iterables.filter(providers = DisplayURLProvider.all(), (Predicate)new Predicate<DisplayURLProvider>(){

            public boolean apply(@Nullable DisplayURLProvider displayURLProvider) {
                if (displayURLProvider == null) {
                    return false;
                }
                return displayURLProvider.getName().equals(providerName);
            }
        })), null)) != null) {
            return provider;
        }
        return this.lookupProvider();
    }

    DisplayURLProvider lookupProvider() {
        PreferredProviderUserProperty prefProperty = this.getUserPreferredProviderProperty();
        if (prefProperty != null && prefProperty.getConfiguredProvider() != null) {
            return prefProperty.getConfiguredProvider();
        }
        DisplayURLProvider displayURLProvider = DisplayURLProvider.getPreferredProvider();
        if (displayURLProvider == null) {
            Iterable<DisplayURLProvider> all = DisplayURLProvider.all();
            Iterable availableProviders = Iterables.filter(all, (Predicate)Predicates.not((Predicate)Predicates.instanceOf(ClassicDisplayURLProvider.class)));
            displayURLProvider = (DisplayURLProvider)Iterables.getFirst((Iterable)availableProviders, (Object)DisplayURLProvider.getDefault());
        }
        return displayURLProvider;
    }

    @VisibleForTesting
    protected PreferredProviderUserProperty getUserPreferredProviderProperty() {
        User user = User.current();
        return user == null ? null : (PreferredProviderUserProperty)user.getProperty(PreferredProviderUserProperty.class);
    }
}

