/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.displayurlapi;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.Job;
import hudson.model.Run;
import hudson.tasks.test.TestResult;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.displayurlapi.ClassicDisplayURLProvider;

public abstract class DisplayURLProvider
implements ExtensionPoint {
    public static DisplayURLProvider get() {
        return DisplayURLProviderImpl.INSTANCE;
    }

    public static Iterable<DisplayURLProvider> all() {
        return DisplayURLProvider.getJenkins().getExtensionList(DisplayURLProvider.class);
    }

    public static DisplayURLProvider getDefault() {
        return (DisplayURLProvider)Iterables.find(DisplayURLProvider.all(), (Predicate)Predicates.instanceOf(ClassicDisplayURLProvider.class));
    }

    public String getRoot() {
        String root = DisplayURLProvider.getJenkins().getRootUrl();
        if (root == null) {
            root = "http://unconfigured-jenkins-location/";
        }
        return Util.encode((String)root);
    }

    public String getDisplayName() {
        return this.getClass().getSimpleName();
    }

    public abstract String getRunURL(Run<?, ?> var1);

    public abstract String getChangesURL(Run<?, ?> var1);

    public abstract String getJobURL(Job<?, ?> var1);

    public abstract String getTestUrl(TestResult var1);

    private static Jenkins getJenkins() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins has not started");
        }
        return jenkins;
    }

    static class DisplayURLProviderImpl
    extends ClassicDisplayURLProvider {
        public static final DisplayURLProvider INSTANCE = new DisplayURLProviderImpl();
        public static final String DISPLAY_POSTFIX = "display/redirect";

        DisplayURLProviderImpl() {
        }

        @Override
        public String getRunURL(Run<?, ?> run) {
            return super.getRunURL(run) + DISPLAY_POSTFIX;
        }

        @Override
        public String getChangesURL(Run<?, ?> run) {
            return super.getRunURL(run) + DISPLAY_POSTFIX + "?page=changes";
        }

        @Override
        public String getJobURL(Job<?, ?> job) {
            return super.getJobURL(job) + DISPLAY_POSTFIX;
        }

        @Override
        public String getTestUrl(TestResult result) {
            Run run = result.getRun();
            return super.getRunURL(run) + DISPLAY_POSTFIX + "?page=test&id=" + Util.rawEncode((String)result.getId());
        }
    }
}

