/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.displayurlapi;

import hudson.Extension;
import hudson.Util;
import hudson.model.Job;
import hudson.model.Run;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestObject;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.displayurlapi.Messages;

@Extension
public class ClassicDisplayURLProvider
extends DisplayURLProvider {
    @Override
    public String getDisplayName() {
        return Messages.classic_name();
    }

    @Override
    public String getRunURL(Run<?, ?> run) {
        return this.getRoot() + Util.encode((String)run.getUrl());
    }

    @Override
    public String getChangesURL(Run<?, ?> run) {
        return this.getJobURL(run.getParent()) + "changes";
    }

    @Override
    public String getJobURL(Job<?, ?> job) {
        return this.getRoot() + Util.encode((String)job.getUrl());
    }

    @Override
    public String getTestUrl(hudson.tasks.test.TestResult result) {
        String buildUrl = this.getRunURL(result.getRun());
        AbstractTestResultAction action = result.getTestResultAction();
        TestResult testResultRoot = null;
        for (TestObject parent = result.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TestResult)) continue;
            testResultRoot = (TestResult)parent;
            break;
        }
        String testUrl = action.getUrlName() + (testResultRoot != null ? testResultRoot.getUrl() : "") + result.getUrl();
        String[] pathComponents = testUrl.split("/");
        StringBuilder buf = new StringBuilder();
        for (String c : pathComponents) {
            buf.append(Util.rawEncode((String)c)).append('/');
        }
        buf.deleteCharAt(buf.length() - 1);
        return buildUrl + buf.toString();
    }
}

