/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.displayurlapi;

import com.google.common.collect.Iterables;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.Job;
import hudson.model.Run;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestObject;
import jenkins.model.Jenkins;

public abstract class DisplayURLProvider
implements ExtensionPoint {
    private static final ClassicDisplayURLProvider CLASSIC_DISPLAY_URL_PROVIDER = new ClassicDisplayURLProvider();

    public static DisplayURLProvider get() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins has not started");
        }
        return (DisplayURLProvider)Iterables.getFirst((Iterable)jenkins.getExtensionList(DisplayURLProvider.class), (Object)CLASSIC_DISPLAY_URL_PROVIDER);
    }

    public abstract String getRoot();

    public abstract String getRunURL(Run<?, ?> var1);

    public abstract String getChangesURL(Run<?, ?> var1);

    public abstract String getJobURL(Job<?, ?> var1);

    public abstract String getTestUrl(hudson.tasks.test.TestResult var1);

    static class ClassicDisplayURLProvider
    extends DisplayURLProvider {
        ClassicDisplayURLProvider() {
        }

        @Override
        public String getRunURL(Run<?, ?> run) {
            return this.getRoot() + run.getUrl();
        }

        @Override
        public String getChangesURL(Run<?, ?> run) {
            return this.getJobURL(run.getParent()) + "changes";
        }

        @Override
        public String getJobURL(Job<?, ?> project) {
            return this.getRoot() + project.getUrl();
        }

        @Override
        public String getRoot() {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                throw new IllegalStateException("Jenkins has not started");
            }
            String root = jenkins.getRootUrl();
            if (root == null) {
                throw new IllegalStateException("Could not determine Jenkins URL. You should set one in Manage Jenkins.");
            }
            return root;
        }

        @Override
        public String getTestUrl(hudson.tasks.test.TestResult result) {
            String buildUrl = this.getRunURL(result.getRun());
            AbstractTestResultAction action = result.getTestResultAction();
            TestResult testResultRoot = null;
            for (TestObject parent = result.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof TestResult)) continue;
                testResultRoot = (TestResult)parent;
                break;
            }
            String testUrl = action.getUrlName() + (testResultRoot != null ? testResultRoot.getUrl() : "") + result.getUrl();
            String[] pathComponents = testUrl.split("/");
            StringBuilder buf = new StringBuilder();
            for (String c : pathComponents) {
                buf.append(Util.rawEncode((String)c)).append('/');
            }
            buf.deleteCharAt(buf.length() - 1);
            return buildUrl + buf.toString();
        }
    }
}

