/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer.resolvers;

import com.cloudbees.plugins.deployer.DeployBuilder;
import com.cloudbees.plugins.deployer.Messages;
import com.cloudbees.plugins.deployer.engines.Engine;
import com.cloudbees.plugins.deployer.hosts.DeployHost;
import com.cloudbees.plugins.deployer.hosts.DeployHostsContext;
import com.cloudbees.plugins.deployer.resolvers.CapabilitiesResolver;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.promoted_builds.Promotion;
import hudson.plugins.promoted_builds.PromotionProcess;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.kohsuke.stapler.DataBoundConstructor;

@Extension(optional=true)
public class PromotionCapabilitiesResolver
extends CapabilitiesResolver {
    private static boolean isPromotionProcess(@NonNull Class<? extends AbstractProject> jobType) {
        try {
            return PromotionCapabilitiesResolver.innerIsPromotionProcess(jobType);
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
        catch (LinkageError e) {
            return false;
        }
    }

    private static boolean innerIsPromotionProcess(Class<? extends AbstractProject> jobType) {
        return PromotionProcess.class.isAssignableFrom(jobType);
    }

    @Override
    protected boolean knows(@NonNull Class<? extends AbstractProject> jobType) {
        return PromotionCapabilitiesResolver.isPromotionProcess(jobType);
    }

    @Override
    @NonNull
    public Set<DeploySourceOrigin> getBuilderSources(@CheckForNull AbstractProject<?, ?> project) {
        return Collections.singleton(DeploySourceOrigin.RUN);
    }

    @Override
    @NonNull
    public Set<DeploySourceOrigin> getPublisherSources(@CheckForNull AbstractProject<?, ?> project) {
        return Collections.singleton(DeploySourceOrigin.RUN);
    }

    @Override
    @NonNull
    public Set<DeploySourceOrigin> getInstantSources(@CheckForNull AbstractProject<?, ?> project) {
        return Collections.singleton(DeploySourceOrigin.RUN);
    }

    @Override
    public Run<?, ?> getLastSuccessfulBuild(AbstractProject<?, ?> project) {
        if (project != null) {
            return CapabilitiesResolver.getLastDeployableBuild(((PromotionProcess)project).getRootProject());
        }
        return null;
    }

    @Override
    public boolean isBuilderApplicable() {
        return false;
    }

    @Override
    public boolean isInstantApplicable() {
        return false;
    }

    @Override
    public boolean isPublisherApplicable() {
        return false;
    }

    public static class DeployPromotionBuilder
    extends DeployBuilder {
        @DataBoundConstructor
        public DeployPromotionBuilder(List<DeployHost<?, ?>> hosts) {
            super(hosts);
        }

        @Override
        public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
            if (build instanceof Promotion) {
                build = ((Promotion)build).getTarget();
            }
            try {
                for (DeployHost<?, ?> set : this.getHosts()) {
                    if (Engine.create(set).withCredentials((Item)build.getProject(), ACL.SYSTEM).from(build, DeploySourceOrigin.RUN).withLauncher(launcher).withListener(listener).build().perform()) continue;
                    return false;
                }
            }
            catch (Throwable t) {
                t.printStackTrace(listener.getLogger());
                return false;
            }
            return true;
        }

        @Extension(optional=true)
        public static final class DescriptorImpl
        extends BuildStepDescriptor<Builder> {
            public boolean isApplicable(Class<? extends AbstractProject> jobType) {
                return PromotionCapabilitiesResolver.isPromotionProcess(jobType);
            }

            public String getDisplayName() {
                return Messages.DeployBuilder_DisplayName();
            }

            public DeployHostsContext<AbstractProject<?, ?>> createHostsContext(AbstractProject<?, ?> it, DeployBuilder instance) {
                Set<DeploySourceOrigin> origins = Collections.singleton(DeploySourceOrigin.RUN);
                return new DeployHostsContext(it, instance == null ? DeployHost.createDefaults(it, origins) : instance.getHosts(), (Job<?, ?>)it, origins, false, false);
            }
        }
    }
}

