/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer.resolvers;

import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionPoint;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Run;
import java.util.Collections;
import java.util.Set;
import jenkins.model.Jenkins;

public abstract class CapabilitiesResolver
implements ExtensionPoint {
    protected abstract boolean knows(@NonNull Class<? extends AbstractProject> var1);

    @NonNull
    public abstract Set<DeploySourceOrigin> getBuilderSources(@CheckForNull AbstractProject<?, ?> var1);

    @NonNull
    public abstract Set<DeploySourceOrigin> getPublisherSources(@CheckForNull AbstractProject<?, ?> var1);

    @NonNull
    public abstract Set<DeploySourceOrigin> getInstantSources(@CheckForNull AbstractProject<?, ?> var1);

    public boolean isBuilderApplicable() {
        return true;
    }

    public boolean isPublisherApplicable() {
        return true;
    }

    public boolean isInstantApplicable() {
        return true;
    }

    public boolean isBuilderFromWorkspace() {
        return true;
    }

    public boolean isPublisherFromWorkspace() {
        return true;
    }

    @CheckForNull
    public abstract Run<?, ?> getLastSuccessfulBuild(@CheckForNull AbstractProject<?, ?> var1);

    @NonNull
    public static CapabilitiesResolver of(@CheckForNull Class<? extends AbstractProject> jobType) {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null && jobType != null) {
            for (CapabilitiesResolver capabilitiesResolver : jenkins.getExtensionList(CapabilitiesResolver.class)) {
                try {
                    if (!capabilitiesResolver.knows(jobType)) continue;
                    return capabilitiesResolver;
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (LinkageError linkageError) {
                }
            }
        }
        return ResourceHolder.defaultResolver;
    }

    @CheckForNull
    public static Run<?, ?> getLastDeployableBuild(@CheckForNull Job<?, ?> job) {
        if (job == null) {
            return null;
        }
        Run run = job.getLastSuccessfulBuild();
        return run != null ? run : job.getLastStableBuild();
    }

    @NonNull
    public static CapabilitiesResolver of(@CheckForNull AbstractProject<?, ?> project) {
        return CapabilitiesResolver.of(project == null ? AbstractProject.class : project.getClass());
    }

    private static class DefaultCapabilitiesResolver
    extends CapabilitiesResolver {
        private DefaultCapabilitiesResolver() {
        }

        @Override
        protected boolean knows(@NonNull Class<? extends AbstractProject> jobType) {
            return true;
        }

        @Override
        @NonNull
        public Set<DeploySourceOrigin> getBuilderSources(@CheckForNull AbstractProject<?, ?> project) {
            return Collections.singleton(DeploySourceOrigin.WORKSPACE);
        }

        @Override
        @NonNull
        public Set<DeploySourceOrigin> getPublisherSources(@CheckForNull AbstractProject<?, ?> project) {
            return DeploySourceOrigin.all();
        }

        @Override
        @NonNull
        public Set<DeploySourceOrigin> getInstantSources(@CheckForNull AbstractProject<?, ?> project) {
            return Collections.singleton(DeploySourceOrigin.RUN);
        }

        @Override
        public Run<?, ?> getLastSuccessfulBuild(AbstractProject<?, ?> project) {
            return DefaultCapabilitiesResolver.getLastDeployableBuild(project);
        }
    }

    private static class ResourceHolder {
        private static final DefaultCapabilitiesResolver defaultResolver = new DefaultCapabilitiesResolver();

        private ResourceHolder() {
        }
    }
}

