/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer.hosts;

import com.cloudbees.plugins.deployer.hosts.DeployHost;
import com.cloudbees.plugins.deployer.resolvers.CapabilitiesResolver;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import com.cloudbees.plugins.deployer.targets.DeployTarget;
import com.cloudbees.plugins.deployer.targets.DeployTargetDescriptor;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;

public abstract class DeployHostDescriptor<S extends DeployHost<S, T>, T extends DeployTarget<T>>
extends Descriptor<DeployHost<S, T>> {
    protected DeployHostDescriptor() {
    }

    protected DeployHostDescriptor(Class<? extends DeployHost<S, T>> clazz) {
        super(clazz);
    }

    @NonNull
    public abstract Class<T> getDeployTargetClass();

    @NonNull
    public DeployTargetDescriptor<T> getDeployTargetDescriptor() {
        return (DeployTargetDescriptor)Hudson.getInstance().getDescriptorOrDie(this.getDeployTargetClass());
    }

    @CheckForNull
    public S createDefault(@CheckForNull AbstractProject<?, ?> owner, @CheckForNull Set<DeploySourceOrigin> origins) {
        return this.createDefault(CapabilitiesResolver.of(owner).getLastSuccessfulBuild(owner), origins);
    }

    @CheckForNull
    public abstract S createDefault(@CheckForNull Run<?, ?> var1, @CheckForNull Set<DeploySourceOrigin> var2);

    @CheckForNull
    public S updateDefault(@CheckForNull AbstractProject<?, ?> owner, @CheckForNull Set<DeploySourceOrigin> origins, @CheckForNull S template) {
        return this.updateDefault(CapabilitiesResolver.of(owner).getLastSuccessfulBuild(owner), origins, template);
    }

    @CheckForNull
    public S updateDefault(@CheckForNull Run<?, ?> run, @CheckForNull Set<DeploySourceOrigin> origins, @CheckForNull S template) {
        return this.createDefault(run, origins);
    }

    public boolean isSupported(@NonNull Set<DeploySourceOrigin> origins, @CheckForNull Class<? extends AbstractProject> jobType) {
        return !this.getDeployTargetDescriptor().getDeploySourceDescriptors(origins, jobType).isEmpty();
    }

    public boolean isSupported(@NonNull Set<DeploySourceOrigin> origins, @CheckForNull Run<?, ?> run) {
        Class<?> jobType = run != null && run.getParent() instanceof AbstractProject ? run.getParent().getClass() : null;
        return this.isSupported(origins, jobType);
    }

    public static ExtensionList<? extends DeployHostDescriptor<?, ?>> all() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            return jenkins.getDescriptorList(DeployHost.class);
        }
        return ExtensionList.create((Jenkins)null, (Class)DeployHostDescriptor.self());
    }

    public static List<DeployHostDescriptor<?, ?>> allSupported(@NonNull Set<DeploySourceOrigin> origins, @CheckForNull Class<? extends AbstractProject> jobType) {
        ArrayList result = new ArrayList();
        for (DeployHostDescriptor d : DeployHostDescriptor.all()) {
            if (!d.isSupported(origins, jobType)) continue;
            result.add(d);
        }
        return result;
    }
}

