/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer.engines;

import com.cloudbees.plugins.deployer.hosts.DeployHost;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import com.cloudbees.plugins.deployer.targets.DeployTarget;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Item;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import net.jcip.annotations.Immutable;
import org.acegisecurity.Authentication;

@Immutable
public class EngineConfiguration<S extends DeployHost<S, T>, T extends DeployTarget<T>> {
    @CheckForNull
    private final Item deployScope;
    @CheckForNull
    private final List<Authentication> deployAuthentications;
    @CheckForNull
    private final AbstractBuild<?, ?> build;
    @NonNull
    private final S configuration;
    @CheckForNull
    private final Launcher launcher;
    @CheckForNull
    private final BuildListener listener;
    @CheckForNull
    private final Set<DeploySourceOrigin> sources;

    public EngineConfiguration(@NonNull S configuration) {
        configuration.getClass();
        this.configuration = configuration;
        this.deployScope = null;
        this.deployAuthentications = null;
        this.build = null;
        this.launcher = null;
        this.listener = null;
        this.sources = null;
    }

    private EngineConfiguration(@CheckForNull AbstractBuild<?, ?> build, @CheckForNull Item deployScope, @CheckForNull List<Authentication> deployAuthentications, @NonNull S configuration, @CheckForNull Launcher launcher, @CheckForNull BuildListener listener, @CheckForNull Set<DeploySourceOrigin> sources) {
        configuration.getClass();
        this.build = build;
        this.deployScope = deployScope;
        this.deployAuthentications = deployAuthentications == null ? null : Collections.unmodifiableList(new ArrayList<Authentication>(deployAuthentications));
        this.configuration = configuration;
        this.launcher = launcher;
        this.listener = listener;
        this.sources = sources == null ? null : Collections.unmodifiableSet(new LinkedHashSet<DeploySourceOrigin>(sources));
    }

    @CheckForNull
    public AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    @NonNull
    public EngineConfiguration<S, T> withBuild(@CheckForNull AbstractBuild<?, ?> build) {
        return new EngineConfiguration<S, T>(build, this.deployScope, this.deployAuthentications, this.configuration, this.launcher, this.listener, this.sources);
    }

    @NonNull
    public S getConfiguration() {
        return this.configuration;
    }

    @CheckForNull
    public List<Authentication> getDeployAuthentications() {
        return this.deployAuthentications;
    }

    @NonNull
    public EngineConfiguration<S, T> withDeployAuthentications(@CheckForNull List<Authentication> deployAuthentications) {
        return new EngineConfiguration<S, T>(this.build, this.deployScope, deployAuthentications, this.configuration, this.launcher, this.listener, this.sources);
    }

    @CheckForNull
    public Item getDeployScope() {
        return this.deployScope;
    }

    @NonNull
    public EngineConfiguration<S, T> withDeployScope(@CheckForNull Item deployScope) {
        return new EngineConfiguration<S, T>(this.build, deployScope, this.deployAuthentications, this.configuration, this.launcher, this.listener, this.sources);
    }

    @CheckForNull
    public Launcher getLauncher() {
        return this.launcher;
    }

    @NonNull
    public EngineConfiguration<S, T> withLauncher(@CheckForNull Launcher launcher) {
        return new EngineConfiguration<S, T>(this.build, this.deployScope, this.deployAuthentications, this.configuration, launcher, this.listener, this.sources);
    }

    @CheckForNull
    public BuildListener getListener() {
        return this.listener;
    }

    @NonNull
    public EngineConfiguration<S, T> withListener(@CheckForNull BuildListener listener) {
        return new EngineConfiguration<S, T>(this.build, this.deployScope, this.deployAuthentications, this.configuration, this.launcher, listener, this.sources);
    }

    @CheckForNull
    public Set<DeploySourceOrigin> getSources() {
        return this.sources;
    }

    @NonNull
    public EngineConfiguration<S, T> withSources(@CheckForNull Set<DeploySourceOrigin> sources) {
        return new EngineConfiguration<S, T>(this.build, this.deployScope, this.deployAuthentications, this.configuration, this.launcher, this.listener, sources);
    }
}

