/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.deployer.engines;

import com.cloudbees.plugins.deployer.DeployEvent;
import com.cloudbees.plugins.deployer.DeployListener;
import com.cloudbees.plugins.deployer.engines.EngineConfiguration;
import com.cloudbees.plugins.deployer.engines.EngineFactory;
import com.cloudbees.plugins.deployer.engines.EngineFactoryDescriptor;
import com.cloudbees.plugins.deployer.exceptions.DeployException;
import com.cloudbees.plugins.deployer.exceptions.DeploySourceNotFoundException;
import com.cloudbees.plugins.deployer.hosts.DeployHost;
import com.cloudbees.plugins.deployer.records.DeployedApplicationAction;
import com.cloudbees.plugins.deployer.records.DeployedApplicationFingerprintFacet;
import com.cloudbees.plugins.deployer.records.DeployedApplicationLocation;
import com.cloudbees.plugins.deployer.sources.DeploySource;
import com.cloudbees.plugins.deployer.sources.DeploySourceOrigin;
import com.cloudbees.plugins.deployer.targets.DeployTarget;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Fingerprint;
import hudson.model.Item;
import hudson.model.Run;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;

public abstract class Engine<S extends DeployHost<S, T>, T extends DeployTarget<T>> {
    private static final String NO_MD5 = "NOMD5";
    protected final Item deployScope;
    protected final List<Authentication> deployAuthentications;
    protected final AbstractBuild<?, ?> build;
    protected final S set;
    protected final Launcher launcher;
    protected final BuildListener listener;
    protected final Set<DeploySourceOrigin> sources;

    protected Engine(EngineConfiguration<S, T> config) {
        List<Authentication> deployAuthentications = config.getDeployAuthentications();
        this.deployAuthentications = deployAuthentications == null ? Arrays.asList(ACL.SYSTEM) : new ArrayList<Authentication>(deployAuthentications);
        this.deployScope = config.getDeployScope();
        this.build = config.getBuild();
        this.launcher = config.getLauncher();
        this.listener = config.getListener();
        this.set = config.getConfiguration();
        Set<DeploySourceOrigin> sources = config.getSources();
        this.sources = sources == null ? new HashSet<DeploySourceOrigin>() : new HashSet<DeploySourceOrigin>(sources);
    }

    public boolean perform() throws Throwable {
        ArrayList<DeploySourceOrigin> validOrigins = new ArrayList<DeploySourceOrigin>(DeploySourceOrigin.allInPreferenceOrder());
        validOrigins.retainAll(this.sources);
        this.logDetails();
        for (DeployTarget target : ((DeployHost)((Object)this.set)).getTargets()) {
            this.log("Deploying " + target.getDisplayName());
            boolean found = false;
            DeployEvent event = this.createEvent(target);
            try {
                DeploySource source = target.getArtifact();
                if (source == null) {
                    throw new DeploySourceNotFoundException(null, "Undefined source for " + target.getDisplayName());
                }
                DeployedApplicationLocation location = null;
                block8: for (DeploySourceOrigin origin : validOrigins) {
                    if (!source.getDescriptor().isSupported(origin)) continue;
                    switch (origin) {
                        case WORKSPACE: {
                            FilePath applicationFile;
                            FilePath workspace = this.build.getWorkspace();
                            if (workspace == null || (applicationFile = source.getApplicationFile(workspace)) == null) continue block8;
                            found = true;
                            this.validate(applicationFile);
                            this.log("  Resolved from workspace as " + applicationFile);
                            location = this.process(applicationFile, target);
                            DeployListener.notifySuccess(this.set, target, event);
                            break block8;
                        }
                        case RUN: {
                            File applicationFile = source.getApplicationFile((Run)this.build);
                            if (applicationFile == null) continue block8;
                            found = true;
                            this.validate(applicationFile);
                            this.log("  Resolved from archived artifacts as " + applicationFile);
                            location = this.process(applicationFile, target);
                            DeployListener.notifySuccess(this.set, target, event);
                            break block8;
                        }
                        default: {
                            DeployListener.notifyFailure(this.set, target, event);
                            throw new UnsupportedOperationException("Unknown DeploySourceOrigin instance: " + (Object)((Object)origin));
                        }
                    }
                }
                if (!found) {
                    throw new DeploySourceNotFoundException(source, "Cannot find source for " + target.getDisplayName());
                }
                if (location == null) continue;
                boolean haveAction = false;
                for (DeployedApplicationAction action : this.build.getActions(DeployedApplicationAction.class)) {
                    if (!((DeployedApplicationLocation)action.getLocation()).equals(location)) continue;
                    haveAction = true;
                    break;
                }
                if (haveAction) continue;
                this.build.addAction(new DeployedApplicationAction<Object>(location));
            }
            catch (RuntimeException e) {
                DeployListener.notifyFailure(this.set, target, event);
                throw e;
            }
            catch (DeployException e) {
                DeployListener.notifyFailure(this.set, target, event);
                throw e;
            }
        }
        return true;
    }

    public abstract void validate(FilePath var1) throws DeployException;

    public abstract void validate(File var1) throws DeployException;

    @CheckForNull
    public DeployedApplicationLocation process(FilePath applicationFile, T target) throws DeployException {
        try {
            FingerprintingWrapper actor = new FingerprintingWrapper(this.newDeployActor(target));
            return this.addToFacets((Map.Entry)applicationFile.act((FilePath.FileCallable)actor));
        }
        catch (DeployException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw new DeployException("Deployment interrupted", e);
        }
        catch (Throwable t) {
            throw new DeployException(t.getMessage(), t);
        }
    }

    @CheckForNull
    public DeployedApplicationLocation process(File applicationFile, T target) throws DeployException {
        try {
            FingerprintingWrapper actor = new FingerprintingWrapper(this.newDeployActor(target));
            return this.addToFacets((Map.Entry<String, DeployedApplicationLocation>)actor.invoke(applicationFile, this.launcher.getChannel()));
        }
        catch (DeployException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw new DeployException("Deployment interrupted", e);
        }
        catch (Throwable t) {
            throw new DeployException(t.getMessage(), t);
        }
    }

    private DeployedApplicationLocation addToFacets(Map.Entry<String, DeployedApplicationLocation> pair) throws IOException {
        DeployedApplicationLocation location = pair.getValue();
        String md5sum = pair.getKey();
        if (!NO_MD5.equals(md5sum)) {
            Jenkins j = Jenkins.getInstance();
            if (j == null) {
                throw new IllegalStateException("Jenkins has not been started, or was already shut down");
            }
            Fingerprint fingerprint = j._getFingerprint(md5sum);
            if (fingerprint != null) {
                fingerprint.getFacets().add(new DeployedApplicationFingerprintFacet<DeployedApplicationLocation>(fingerprint, System.currentTimeMillis(), location));
                fingerprint.save();
                this.listener.getLogger().println("[cloudbees-deployer] Recorded deployment in fingerprint record");
            } else {
                this.listener.getLogger().println("[cloudbees-deployer] Deployed artifact does not have a fingerprint record");
            }
        }
        return location;
    }

    protected abstract FilePath.FileCallable<DeployedApplicationLocation> newDeployActor(T var1) throws DeployException;

    public abstract DeployEvent createEvent(T var1) throws DeployException;

    public abstract void logDetails();

    public void log(String message) {
        this.listener.getLogger().println("[cloudbees-deployer] " + message);
    }

    public static EngineFactory<?, ?> create(DeployHost<?, ?> configuration) throws DeployException {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new IllegalStateException("Jenkins has shut down or not started.");
        }
        for (Object d : jenkins.getDescriptorList(EngineFactory.class)) {
            EngineFactoryDescriptor descriptor;
            if (!(d instanceof EngineFactoryDescriptor) || !(descriptor = (EngineFactoryDescriptor)((Object)EngineFactoryDescriptor.class.cast(d))).isApplicable(((Object)configuration).getClass())) continue;
            return descriptor.newFactory(configuration);
        }
        throw new DeployException("Deployment hosts of type " + ((Object)configuration).getClass() + " are unsupported");
    }

    public static class FingerprintingWrapper
    extends MasterToSlaveFileCallable<Map.Entry<String, DeployedApplicationLocation>> {
        private final FilePath.FileCallable<DeployedApplicationLocation> delegate;

        public FingerprintingWrapper(FilePath.FileCallable<DeployedApplicationLocation> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map.Entry<String, DeployedApplicationLocation> invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            DeployedApplicationLocation location = (DeployedApplicationLocation)this.delegate.invoke(f, channel);
            if (f.isFile() && location != null) {
                try (FileInputStream fis = new FileInputStream(f);){
                    String md5sum = Util.getDigestOf((InputStream)fis);
                    AbstractMap.SimpleEntry<String, DeployedApplicationLocation> simpleEntry = new AbstractMap.SimpleEntry<String, DeployedApplicationLocation>(md5sum, location);
                    return simpleEntry;
                }
            }
            return new AbstractMap.SimpleEntry<String, DeployedApplicationLocation>(Engine.NO_MD5, location);
        }
    }
}

