/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.depgraph_view.model.graph;

import com.google.common.base.Preconditions;
import hudson.model.AbstractProject;
import hudson.model.FreeStyleProject;
import hudson.plugins.depgraph_view.model.graph.ProjectNode;
import hudson.plugins.depgraph_view.model.graph.SubProjectProvider;
import hudson.plugins.parameterizedtrigger.BlockableBuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.TriggerBuilder;
import hudson.tasks.Builder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import jenkins.model.Jenkins;

public class ParameterizedTriggerSubProjectProvider
implements SubProjectProvider {
    private final boolean isParameterizedTriggerPluginInstalled;

    @Inject
    public ParameterizedTriggerSubProjectProvider(Jenkins jenkins) {
        this.isParameterizedTriggerPluginInstalled = jenkins.getPlugin("parameterized-trigger") != null;
    }

    @Override
    public Iterable<ProjectNode> getSubProjectsOf(AbstractProject<?, ?> project) {
        Preconditions.checkNotNull(project);
        if (!this.isParameterizedTriggerPluginInstalled) {
            return Collections.emptyList();
        }
        ArrayList<ProjectNode> subProjects = new ArrayList<ProjectNode>();
        if (project instanceof FreeStyleProject) {
            FreeStyleProject proj = (FreeStyleProject)project;
            List builders = proj.getBuilders();
            for (Builder builder : builders) {
                if (!(builder instanceof TriggerBuilder)) continue;
                TriggerBuilder tBuilder = (TriggerBuilder)builder;
                for (BlockableBuildTriggerConfig config : tBuilder.getConfigs()) {
                    for (AbstractProject abstractProject : config.getProjectList(null)) {
                        subProjects.add(ProjectNode.node(abstractProject));
                    }
                }
            }
        }
        return subProjects;
    }
}

