/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.depgraph_view.model.graph;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.plugins.depgraph_view.model.graph.DependencyGraph;
import hudson.plugins.depgraph_view.model.graph.EdgeProvider;
import hudson.plugins.depgraph_view.model.graph.ProjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;

public class GraphCalculator {
    private Set<EdgeProvider> edgeProviders;

    @Inject
    public GraphCalculator(Set<EdgeProvider> edgeProviders) {
        this.edgeProviders = Sets.newHashSet(edgeProviders);
    }

    public DependencyGraph generateGraph(Iterable<ProjectNode> initialProjects) {
        DependencyGraph graph = new DependencyGraph();
        graph.addNodes(initialProjects);
        this.extendGraph(graph, initialProjects);
        return graph;
    }

    private void extendGraph(DependencyGraph graph, Iterable<ProjectNode> fromProjects) {
        ArrayList newEdges = Lists.newArrayList();
        for (ProjectNode projectNode : fromProjects) {
            AbstractProject<?, ?> project = projectNode.getProject();
            if (!project.hasPermission(Item.READ)) continue;
            for (EdgeProvider edgeProvider : this.edgeProviders) {
                Iterables.addAll((Collection)newEdges, edgeProvider.getEdgesIncidentWith(project));
            }
        }
        Set<ProjectNode> newProj = graph.addEdgesWithNodes(newEdges);
        if (!newProj.isEmpty()) {
            this.extendGraph(graph, newProj);
        }
    }

    public static Iterable<ProjectNode> abstractProjectSetToProjectNodeSet(Iterable<? extends AbstractProject<?, ?>> projects) {
        return Iterables.transform(projects, (Function)new Function<AbstractProject<?, ?>, ProjectNode>(){

            public ProjectNode apply(AbstractProject<?, ?> input) {
                return ProjectNode.node(input);
            }
        });
    }
}

