/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyTrack;

import hudson.model.Action;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.DependencyTrack.Messages;

public class ResultLinkAction
implements Action,
Serializable {
    private static final long serialVersionUID = 9144463546984654654L;
    private final String dependencyTrackUrl;
    private final String projectId;
    private String projectName;
    private String projectVersion;

    public String getIconFileName() {
        return this.isEnabled() ? "/plugin/dependency-track/icons/dt-logo-symbol.svg" : null;
    }

    public String getDisplayName() {
        return this.isEnabled() ? Messages.Result_DT_Project() : null;
    }

    public String getUrlName() {
        try {
            return this.isEnabled() ? String.format("%s/project/?uuid=%s", this.dependencyTrackUrl, URLEncoder.encode(this.projectId, StandardCharsets.UTF_8.name())) : null;
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    private boolean isEnabled() {
        return StringUtils.isNotBlank((String)this.dependencyTrackUrl) && StringUtils.isNotBlank((String)this.projectId);
    }

    @Generated
    public String getDependencyTrackUrl() {
        return this.dependencyTrackUrl;
    }

    @Generated
    public String getProjectId() {
        return this.projectId;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public String getProjectVersion() {
        return this.projectVersion;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResultLinkAction)) {
            return false;
        }
        ResultLinkAction other = (ResultLinkAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dependencyTrackUrl = this.getDependencyTrackUrl();
        String other$dependencyTrackUrl = other.getDependencyTrackUrl();
        if (this$dependencyTrackUrl == null ? other$dependencyTrackUrl != null : !this$dependencyTrackUrl.equals(other$dependencyTrackUrl)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$projectVersion = this.getProjectVersion();
        String other$projectVersion = other.getProjectVersion();
        return !(this$projectVersion == null ? other$projectVersion != null : !this$projectVersion.equals(other$projectVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ResultLinkAction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dependencyTrackUrl = this.getDependencyTrackUrl();
        result = result * 59 + ($dependencyTrackUrl == null ? 43 : $dependencyTrackUrl.hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $projectVersion = this.getProjectVersion();
        result = result * 59 + ($projectVersion == null ? 43 : $projectVersion.hashCode());
        return result;
    }

    @Generated
    public ResultLinkAction(String dependencyTrackUrl, String projectId) {
        this.dependencyTrackUrl = dependencyTrackUrl;
        this.projectId = projectId;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }
}

