/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyTrack;

import hudson.model.InvisibleAction;
import hudson.model.Job;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import net.sf.json.JSONArray;
import org.jenkinsci.plugins.DependencyTrack.ResultAction;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class JobAction
extends InvisibleAction {
    @NonNull
    private final Job<?, ?> project;

    public String getUrlName() {
        return "dtrackTrend";
    }

    public boolean isTrendVisible() {
        return this.project.getBuilds().stream().map(run -> (ResultAction)run.getAction(ResultAction.class)).anyMatch(Objects::nonNull);
    }

    @JavaScriptMethod
    public JSONArray getSeverityDistributionTrend() {
        List severityDistributions = this.project.getBuilds().stream().sorted(Comparator.naturalOrder()).map(run -> (ResultAction)run.getAction(ResultAction.class)).filter(Objects::nonNull).map(ResultAction::getSeverityDistribution).collect(Collectors.toList());
        return JSONArray.fromObject(severityDistributions);
    }

    @Generated
    public JobAction(@NonNull Job<?, ?> project) {
        if (project == null) {
            throw new NullPointerException("project is marked non-null but is null");
        }
        this.project = project;
    }

    @NonNull
    @Generated
    public Job<?, ?> getProject() {
        return this.project;
    }
}

