/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyTrack;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.util.Secret;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import jenkins.tasks.SimpleBuildStep;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.DependencyTrack.ApiClient;
import org.jenkinsci.plugins.DependencyTrack.ApiClientException;
import org.jenkinsci.plugins.DependencyTrack.ApiClientFactory;
import org.jenkinsci.plugins.DependencyTrack.ConsoleLogger;
import org.jenkinsci.plugins.DependencyTrack.DescriptorImpl;
import org.jenkinsci.plugins.DependencyTrack.Messages;
import org.jenkinsci.plugins.DependencyTrack.PluginUtil;
import org.jenkinsci.plugins.DependencyTrack.ResultAction;
import org.jenkinsci.plugins.DependencyTrack.ResultLinkAction;
import org.jenkinsci.plugins.DependencyTrack.ThresholdCapablePublisher;
import org.jenkinsci.plugins.DependencyTrack.model.Finding;
import org.jenkinsci.plugins.DependencyTrack.model.RiskGate;
import org.jenkinsci.plugins.DependencyTrack.model.SeverityDistribution;
import org.jenkinsci.plugins.DependencyTrack.model.UploadResult;
import org.jenkinsci.plugins.DependencyTrack.model.Vulnerability;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class DependencyTrackPublisher
extends ThresholdCapablePublisher
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 480115440498217963L;
    private String projectId;
    private String projectName;
    private String projectVersion;
    private final String artifact;
    private final boolean synchronous;
    private String dependencyTrackUrl;
    private String dependencyTrackFrontendUrl;
    private String dependencyTrackApiKey;
    private Boolean autoCreateProjects;
    private transient ApiClientFactory clientFactory;
    private transient DescriptorImpl descriptor;
    private transient boolean overrideGlobals;

    @DataBoundConstructor
    public DependencyTrackPublisher(String artifact, boolean synchronous) {
        this(artifact, synchronous, ApiClient::new);
    }

    DependencyTrackPublisher(String artifact, boolean synchronous, @NonNull ApiClientFactory clientFactory) {
        if (clientFactory == null) {
            throw new NullPointerException("clientFactory is marked non-null but is null");
        }
        this.artifact = artifact;
        this.synchronous = synchronous;
        this.clientFactory = clientFactory;
        this.descriptor = this.getDescriptor();
    }

    public void perform(@edu.umd.cs.findbugs.annotations.NonNull Run<?, ?> run, @edu.umd.cs.findbugs.annotations.NonNull FilePath workspace, @edu.umd.cs.findbugs.annotations.NonNull EnvVars env, @edu.umd.cs.findbugs.annotations.NonNull Launcher launcher, @edu.umd.cs.findbugs.annotations.NonNull TaskListener listener) throws InterruptedException, IOException {
        ConsoleLogger logger = new ConsoleLogger(listener.getLogger());
        String effectiveProjectName = env.expand(this.projectName);
        String effectiveProjectVersion = env.expand(this.projectVersion);
        String effectiveArtifact = env.expand(this.artifact);
        boolean effectiveAutocreate = this.isEffectiveAutoCreateProjects();
        if (StringUtils.isBlank((String)effectiveArtifact)) {
            logger.log(Messages.Builder_Artifact_Unspecified());
            throw new AbortException(Messages.Builder_Artifact_Unspecified());
        }
        if (StringUtils.isBlank((String)this.projectId) && (StringUtils.isBlank((String)effectiveProjectName) || StringUtils.isBlank((String)effectiveProjectVersion))) {
            logger.log(Messages.Builder_Result_InvalidArguments());
            throw new AbortException(Messages.Builder_Result_InvalidArguments());
        }
        if (StringUtils.isBlank((String)this.projectId) && !effectiveAutocreate) {
            logger.log(Messages.Builder_Result_ProjectIdMissing());
            throw new AbortException(Messages.Builder_Result_ProjectIdMissing());
        }
        FilePath artifactFilePath = new FilePath(workspace, effectiveArtifact);
        if (!artifactFilePath.exists()) {
            logger.log(Messages.Builder_Artifact_NonExist(effectiveArtifact));
            throw new AbortException(Messages.Builder_Artifact_NonExist(effectiveArtifact));
        }
        String effectiveUrl = this.getEffectiveUrl();
        String effectiveApiKey = this.getEffectiveApiKey(run);
        logger.log(Messages.Builder_Publishing(effectiveUrl));
        ApiClient apiClient = this.clientFactory.create(effectiveUrl, effectiveApiKey, logger, this.descriptor.getDependencyTrackConnectionTimeout(), this.descriptor.getDependencyTrackReadTimeout());
        UploadResult uploadResult = apiClient.upload(this.projectId, effectiveProjectName, effectiveProjectVersion, artifactFilePath, effectiveAutocreate);
        if (!uploadResult.isSuccess()) {
            throw new AbortException(Messages.Builder_Upload_Failed());
        }
        ResultLinkAction linkAction = new ResultLinkAction(this.getEffectiveFrontendUrl(), this.projectId);
        linkAction.setProjectName(effectiveProjectName);
        linkAction.setProjectVersion(effectiveProjectVersion);
        run.addOrReplaceAction((Action)linkAction);
        logger.log(Messages.Builder_Success(String.format("%s/projects/%s", this.getEffectiveFrontendUrl(), this.projectId != null ? this.projectId : "")));
        if (this.synchronous && StringUtils.isNotBlank((String)uploadResult.getToken())) {
            this.publishAnalysisResult(logger, apiClient, uploadResult.getToken(), run, effectiveProjectName, effectiveProjectVersion);
        }
    }

    private void publishAnalysisResult(ConsoleLogger logger, ApiClient apiClient, String token, Run<?, ?> build, String effectiveProjectName, String effectiveProjectVersion) throws InterruptedException, ApiClientException, AbortException {
        long timeout = System.currentTimeMillis() + 60000L * (long)this.descriptor.getDependencyTrackPollingTimeout();
        long interval = 1000L * (long)this.descriptor.getDependencyTrackPollingInterval();
        logger.log(Messages.Builder_Polling());
        Thread.sleep(interval);
        while (apiClient.isTokenBeingProcessed(token)) {
            Thread.sleep(interval);
            if (timeout >= System.currentTimeMillis()) continue;
            logger.log(Messages.Builder_Polling_Timeout_Exceeded());
            throw new AbortException(Messages.Builder_Polling_Timeout_Exceeded());
        }
        if (StringUtils.isBlank((String)this.projectId)) {
            logger.log(Messages.Builder_Project_Lookup(effectiveProjectName, effectiveProjectVersion));
            this.projectId = apiClient.lookupProject(effectiveProjectName, effectiveProjectVersion).getUuid();
        }
        logger.log(Messages.Builder_Findings_Processing());
        List<Finding> findings = apiClient.getFindings(this.projectId);
        SeverityDistribution severityDistribution = new SeverityDistribution(build.getNumber());
        findings.stream().map(Finding::getVulnerability).map(Vulnerability::getSeverity).forEach(severityDistribution::add);
        ResultAction projectAction = new ResultAction(findings, severityDistribution);
        projectAction.setDependencyTrackUrl(this.getEffectiveFrontendUrl());
        projectAction.setProjectId(this.projectId);
        build.addOrReplaceAction((Action)projectAction);
        ResultLinkAction linkAction = new ResultLinkAction(this.getEffectiveFrontendUrl(), this.projectId);
        linkAction.setProjectName(effectiveProjectName);
        linkAction.setProjectVersion(effectiveProjectVersion);
        build.addOrReplaceAction((Action)linkAction);
        SeverityDistribution previousSeverityDistribution = Optional.ofNullable(build.getPreviousBuild()).map(previousBuild -> (ResultAction)previousBuild.getAction(ResultAction.class)).map(ResultAction::getSeverityDistribution).orElse(new SeverityDistribution(0));
        this.evaluateRiskGates(build, logger, severityDistribution, previousSeverityDistribution);
    }

    private void evaluateRiskGates(Run<?, ?> build, ConsoleLogger logger, SeverityDistribution currentDistribution, SeverityDistribution previousDistribution) throws AbortException {
        RiskGate riskGate = new RiskGate(this.getThresholds());
        Result result = riskGate.evaluate(currentDistribution, previousDistribution);
        if (result.isWorseOrEqualTo(Result.UNSTABLE) && result.isCompleteBuild()) {
            logger.log(Messages.Builder_Threshold_Exceed());
            build.setResult(result);
        }
        if (result.isWorseThan(Result.UNSTABLE) && result.isCompleteBuild()) {
            throw new AbortException(Messages.Builder_Threshold_Exceed());
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.clientFactory == null) {
            this.clientFactory = ApiClient::new;
        }
        if (this.descriptor == null) {
            this.descriptor = this.getDescriptor();
        }
        this.overrideGlobals = StringUtils.isNotBlank((String)this.dependencyTrackUrl) || StringUtils.isNotBlank((String)this.dependencyTrackFrontendUrl) || StringUtils.isNotBlank((String)this.dependencyTrackApiKey) || this.autoCreateProjects != null;
        return this;
    }

    private Object writeReplace() throws ObjectStreamException {
        if (!this.overrideGlobals) {
            this.dependencyTrackUrl = null;
            this.dependencyTrackFrontendUrl = null;
            this.dependencyTrackApiKey = null;
            this.autoCreateProjects = null;
        }
        if (!this.isEffectiveAutoCreateProjects()) {
            this.projectName = null;
            this.projectVersion = null;
        }
        return this;
    }

    @edu.umd.cs.findbugs.annotations.NonNull
    private String getEffectiveUrl() {
        String url = Optional.ofNullable(PluginUtil.parseBaseUrl(this.dependencyTrackUrl)).orElse(this.descriptor.getDependencyTrackUrl());
        return Optional.ofNullable(url).orElse("");
    }

    @edu.umd.cs.findbugs.annotations.NonNull
    private String getEffectiveFrontendUrl() {
        String url = Optional.ofNullable(PluginUtil.parseBaseUrl(this.dependencyTrackFrontendUrl)).orElse(this.descriptor.getDependencyTrackFrontendUrl());
        return Optional.ofNullable(url).orElse(this.getEffectiveUrl());
    }

    @edu.umd.cs.findbugs.annotations.NonNull
    private String getEffectiveApiKey(@edu.umd.cs.findbugs.annotations.NonNull Run<?, ?> run) {
        String credId = Optional.ofNullable(StringUtils.trimToNull((String)this.dependencyTrackApiKey)).orElse(this.descriptor.getDependencyTrackApiKey());
        if (credId != null) {
            StringCredentials cred = (StringCredentials)CredentialsProvider.findCredentialById((String)credId, StringCredentials.class, run, (DomainRequirement[])new DomainRequirement[0]);
            return Optional.ofNullable((StringCredentials)CredentialsProvider.track(run, (Credentials)cred)).map(StringCredentials::getSecret).map(Secret::getPlainText).orElse(credId);
        }
        return "";
    }

    public boolean isEffectiveAutoCreateProjects() {
        return Optional.ofNullable(this.autoCreateProjects).orElse(this.descriptor.isDependencyTrackAutoCreateProjects());
    }

    @Generated
    public String getProjectId() {
        return this.projectId;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public String getProjectVersion() {
        return this.projectVersion;
    }

    @Generated
    public String getArtifact() {
        return this.artifact;
    }

    @Generated
    public boolean isSynchronous() {
        return this.synchronous;
    }

    @Generated
    public String getDependencyTrackUrl() {
        return this.dependencyTrackUrl;
    }

    @Generated
    public String getDependencyTrackFrontendUrl() {
        return this.dependencyTrackFrontendUrl;
    }

    @Generated
    public String getDependencyTrackApiKey() {
        return this.dependencyTrackApiKey;
    }

    @Generated
    public Boolean getAutoCreateProjects() {
        return this.autoCreateProjects;
    }

    @Generated
    public boolean isOverrideGlobals() {
        return this.overrideGlobals;
    }

    @DataBoundSetter
    @Generated
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @DataBoundSetter
    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @DataBoundSetter
    @Generated
    public void setProjectVersion(String projectVersion) {
        this.projectVersion = projectVersion;
    }

    @DataBoundSetter
    @Generated
    public void setDependencyTrackUrl(String dependencyTrackUrl) {
        this.dependencyTrackUrl = dependencyTrackUrl;
    }

    @DataBoundSetter
    @Generated
    public void setDependencyTrackFrontendUrl(String dependencyTrackFrontendUrl) {
        this.dependencyTrackFrontendUrl = dependencyTrackFrontendUrl;
    }

    @DataBoundSetter
    @Generated
    public void setDependencyTrackApiKey(String dependencyTrackApiKey) {
        this.dependencyTrackApiKey = dependencyTrackApiKey;
    }

    @DataBoundSetter
    @Generated
    public void setAutoCreateProjects(Boolean autoCreateProjects) {
        this.autoCreateProjects = autoCreateProjects;
    }

    @DataBoundSetter
    @Generated
    public void setOverrideGlobals(boolean overrideGlobals) {
        this.overrideGlobals = overrideGlobals;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyTrackPublisher)) {
            return false;
        }
        DependencyTrackPublisher other = (DependencyTrackPublisher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$projectVersion = this.getProjectVersion();
        String other$projectVersion = other.getProjectVersion();
        if (this$projectVersion == null ? other$projectVersion != null : !this$projectVersion.equals(other$projectVersion)) {
            return false;
        }
        String this$artifact = this.getArtifact();
        String other$artifact = other.getArtifact();
        if (this$artifact == null ? other$artifact != null : !this$artifact.equals(other$artifact)) {
            return false;
        }
        if (this.isSynchronous() != other.isSynchronous()) {
            return false;
        }
        String this$dependencyTrackUrl = this.getDependencyTrackUrl();
        String other$dependencyTrackUrl = other.getDependencyTrackUrl();
        if (this$dependencyTrackUrl == null ? other$dependencyTrackUrl != null : !this$dependencyTrackUrl.equals(other$dependencyTrackUrl)) {
            return false;
        }
        String this$dependencyTrackFrontendUrl = this.getDependencyTrackFrontendUrl();
        String other$dependencyTrackFrontendUrl = other.getDependencyTrackFrontendUrl();
        if (this$dependencyTrackFrontendUrl == null ? other$dependencyTrackFrontendUrl != null : !this$dependencyTrackFrontendUrl.equals(other$dependencyTrackFrontendUrl)) {
            return false;
        }
        String this$dependencyTrackApiKey = this.getDependencyTrackApiKey();
        String other$dependencyTrackApiKey = other.getDependencyTrackApiKey();
        if (this$dependencyTrackApiKey == null ? other$dependencyTrackApiKey != null : !this$dependencyTrackApiKey.equals(other$dependencyTrackApiKey)) {
            return false;
        }
        Boolean this$autoCreateProjects = this.getAutoCreateProjects();
        Boolean other$autoCreateProjects = other.getAutoCreateProjects();
        return !(this$autoCreateProjects == null ? other$autoCreateProjects != null : !((Object)this$autoCreateProjects).equals(other$autoCreateProjects));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DependencyTrackPublisher;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $projectVersion = this.getProjectVersion();
        result = result * 59 + ($projectVersion == null ? 43 : $projectVersion.hashCode());
        String $artifact = this.getArtifact();
        result = result * 59 + ($artifact == null ? 43 : $artifact.hashCode());
        result = result * 59 + (this.isSynchronous() ? 79 : 97);
        String $dependencyTrackUrl = this.getDependencyTrackUrl();
        result = result * 59 + ($dependencyTrackUrl == null ? 43 : $dependencyTrackUrl.hashCode());
        String $dependencyTrackFrontendUrl = this.getDependencyTrackFrontendUrl();
        result = result * 59 + ($dependencyTrackFrontendUrl == null ? 43 : $dependencyTrackFrontendUrl.hashCode());
        String $dependencyTrackApiKey = this.getDependencyTrackApiKey();
        result = result * 59 + ($dependencyTrackApiKey == null ? 43 : $dependencyTrackApiKey.hashCode());
        Boolean $autoCreateProjects = this.getAutoCreateProjects();
        result = result * 59 + ($autoCreateProjects == null ? 43 : ((Object)$autoCreateProjects).hashCode());
        return result;
    }
}

