/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck.pipeline;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.DependencyCheck.DependencyCheckPublisher;
import org.jenkinsci.plugins.DependencyCheck.Messages;
import org.jenkinsci.plugins.DependencyCheck.pipeline.DependencyCheckStep;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class DependencyCheckStepExecutor
extends SynchronousNonBlockingStepExecution<Void> {
    private static final long serialVersionUID = -8209320657657318589L;
    private DependencyCheckStep step;

    protected DependencyCheckStepExecutor(@NonNull DependencyCheckStep step, @NonNull StepContext context) {
        super(context);
        this.step = step;
    }

    protected Void run() throws Exception {
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        workspace.mkdirs();
        Run run = (Run)this.getContext().get(Run.class);
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        FlowNode node = (FlowNode)this.getContext().get(FlowNode.class);
        Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
        DependencyCheckPublisher publisher = new DependencyCheckPublisher();
        publisher.setPattern(this.step.getPattern());
        publisher.setStopBuild(this.step.isStopBuild());
        publisher.setTotalThresholdAnalysisExploitable(this.step.isTotalThresholdAnalysisExploitable());
        publisher.setFailedTotalCritical(this.step.getFailedTotalCritical());
        publisher.setFailedTotalHigh(this.step.getFailedTotalHigh());
        publisher.setFailedTotalMedium(this.step.getFailedTotalMedium());
        publisher.setFailedTotalLow(this.step.getFailedTotalLow());
        publisher.setUnstableTotalCritical(this.step.getUnstableTotalCritical());
        publisher.setUnstableTotalHigh(this.step.getUnstableTotalHigh());
        publisher.setUnstableTotalMedium(this.step.getUnstableTotalMedium());
        publisher.setUnstableTotalLow(this.step.getUnstableTotalLow());
        publisher.setNewThresholdAnalysisExploitable(this.step.isNewThresholdAnalysisExploitable());
        publisher.setFailedNewCritical(this.step.getFailedNewCritical());
        publisher.setFailedNewHigh(this.step.getFailedNewHigh());
        publisher.setFailedNewMedium(this.step.getFailedNewMedium());
        publisher.setFailedNewLow(this.step.getFailedNewLow());
        publisher.setUnstableNewCritical(this.step.getUnstableNewCritical());
        publisher.setUnstableNewHigh(this.step.getUnstableNewHigh());
        publisher.setUnstableNewMedium(this.step.getUnstableNewMedium());
        publisher.setUnstableNewLow(this.step.getUnstableNewLow());
        Result result = publisher.process(run, workspace, launcher, listener);
        if (result.isWorseThan(Result.SUCCESS)) {
            node.addOrReplaceAction((Action)new WarningAction(result).withMessage(Messages.Publisher_Threshold_Exceed()));
            run.setResult(result);
        }
        if (Result.FAILURE == result && this.step.isStopBuild()) {
            throw new AbortException(Messages.Publisher_Threshold_Exceed());
        }
        return null;
    }
}

