/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck.transformer;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jenkins.ui.symbol.Symbol;
import org.jenkins.ui.symbol.SymbolRequest;
import org.jenkinsci.plugins.DependencyCheck.model.Dependency;
import org.jenkinsci.plugins.DependencyCheck.model.Finding;
import org.jenkinsci.plugins.DependencyCheck.model.Severity;
import org.jenkinsci.plugins.DependencyCheck.model.Vulnerability;

public class FindingsTransformer {
    private static final String FONT_AWESOME_API = "font-awesome-api";
    private String bugSymbol;

    public FindingsTransformer() {
        this.initSymbols();
    }

    protected void initSymbols() {
        this.bugSymbol = Symbol.get((SymbolRequest)new SymbolRequest.Builder().withName("solid/bug").withPluginName(FONT_AWESOME_API).withClasses("no-issues-banner small-svg-icon").build());
    }

    public JSONObject transform(List<Finding> findings) {
        JSONArray columns = new JSONArray();
        JSONObject fileName = new JSONObject();
        fileName.put("name", (Object)"dependency.fileName");
        fileName.put("title", (Object)"File Name");
        fileName.put("visible", (Object)true);
        fileName.put("filterable", (Object)true);
        columns.add((Object)fileName);
        JSONObject filePath = new JSONObject();
        filePath.put("name", (Object)"dependency.filePath");
        filePath.put("title", (Object)"File Path");
        filePath.put("breakpoints", (Object)"all");
        filePath.put("visible", (Object)true);
        filePath.put("filterable", (Object)false);
        columns.add((Object)filePath);
        JSONObject sha1 = new JSONObject();
        sha1.put("name", (Object)"dependency.sha1");
        sha1.put("title", (Object)"SHA-1");
        sha1.put("breakpoints", (Object)"all");
        sha1.put("visible", (Object)true);
        sha1.put("filterable", (Object)true);
        columns.add((Object)sha1);
        JSONObject sha256 = new JSONObject();
        sha256.put("name", (Object)"dependency.sha256");
        sha256.put("title", (Object)"SHA-256");
        sha256.put("breakpoints", (Object)"all");
        sha256.put("visible", (Object)true);
        sha256.put("filterable", (Object)true);
        columns.add((Object)sha256);
        JSONObject vulnNameLabel = new JSONObject();
        vulnNameLabel.put("name", (Object)"vulnerability.nameLabel");
        vulnNameLabel.put("title", (Object)"Vulnerability");
        vulnNameLabel.put("visible", (Object)true);
        vulnNameLabel.put("filterable", (Object)true);
        columns.add((Object)vulnNameLabel);
        JSONObject severityLabel = new JSONObject();
        severityLabel.put("name", (Object)"vulnerability.severityLabel");
        severityLabel.put("title", (Object)"Severity");
        severityLabel.put("visible", (Object)true);
        severityLabel.put("filterable", (Object)true);
        columns.add((Object)severityLabel);
        JSONObject cwe = new JSONObject();
        cwe.put("name", (Object)"vulnerability.cwe");
        cwe.put("title", (Object)"Weakness");
        cwe.put("visible", (Object)true);
        cwe.put("filterable", (Object)true);
        columns.add((Object)cwe);
        JSONObject vulnDescription = new JSONObject();
        vulnDescription.put("name", (Object)"vulnerability.description");
        vulnDescription.put("title", (Object)"Description");
        vulnDescription.put("breakpoints", (Object)"all");
        vulnDescription.put("visible", (Object)true);
        vulnDescription.put("filterable", (Object)false);
        columns.add((Object)vulnDescription);
        JSONObject vulnReferences = new JSONObject();
        vulnReferences.put("name", (Object)"vulnerability.references");
        vulnReferences.put("title", (Object)"References");
        vulnReferences.put("breakpoints", (Object)"all");
        vulnReferences.put("visible", (Object)true);
        vulnReferences.put("filterable", (Object)false);
        columns.add((Object)vulnReferences);
        JSONArray rows = new JSONArray();
        for (Finding finding : findings) {
            Dependency dependency = finding.getDependency();
            Vulnerability vulnerability = finding.getVulnerability();
            JSONObject row = new JSONObject();
            row.put("dependency.fileName", (Object)this.createCellWithSortValue(this.escape(dependency.getFileName()), this.escape(dependency.getFilePath())));
            row.put("dependency.filePath", (Object)this.escape(dependency.getFilePath()));
            row.put("dependency.description", (Object)this.escape(dependency.getDescription()));
            row.put("dependency.license", (Object)this.escape(dependency.getLicense()));
            row.put("dependency.md5", (Object)this.escape(dependency.getMd5()));
            row.put("dependency.sha1", (Object)this.escape(dependency.getSha1()));
            row.put("dependency.sha256", (Object)this.escape(dependency.getSha256()));
            row.put("vulnerability.source", (Object)vulnerability.getSource());
            row.put("vulnerability.name", (Object)this.escape(vulnerability.getName()));
            row.put("vulnerability.nameLabel", (Object)this.createCellWithSortValue(this.generateVulnerabilityField(vulnerability), this.escape(vulnerability.getName())));
            row.put("vulnerability.description", (Object)this.escape(vulnerability.getDescription()));
            if (CollectionUtils.isNotEmpty(vulnerability.getReferences())) {
                StringBuilder referecens = new StringBuilder();
                vulnerability.getReferences().forEach(ref -> {
                    if (this.isURL(ref.getUrl())) {
                        referecens.append("<a href=\"" + ref.getUrl() + "\" target=\"_blank\">");
                        referecens.append(this.escape(ref.getName()));
                        referecens.append("</a>");
                        referecens.append("<br />");
                        referecens.append("\n");
                    }
                });
                row.put("vulnerability.references", (Object)referecens.toString());
            }
            row.put("vulnerability.severityLabel", (Object)this.createCellWithSortValue(this.generateSeverityField(Severity.normalize(vulnerability.getSeverity())), Severity.normalize(vulnerability.getSeverity()).ordinal()));
            row.put("vulnerability.severity", (Object)vulnerability.getSeverity());
            row.put("vulnerability.severityRank", (Object)Severity.normalize(vulnerability.getSeverity()).ordinal());
            if (CollectionUtils.isNotEmpty(vulnerability.getCwes())) {
                row.put("vulnerability.cwe", (Object)vulnerability.getCwes().get(0));
            }
            rows.add((Object)row);
        }
        JSONObject data = new JSONObject();
        data.put("columns", (Object)columns);
        data.put("rows", (Object)rows);
        return data;
    }

    private boolean isURL(String url) {
        if (StringUtils.isNotBlank((CharSequence)url)) {
            try {
                new URL(url);
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return false;
    }

    private String escape(String content) {
        return StringEscapeUtils.escapeHtml4((String)StringUtils.trimToEmpty((String)content));
    }

    private JSONObject createCellWithSortValue(Object aValue, Object aSortValue) {
        JSONObject tObject = new JSONObject();
        tObject.put("value", (Object)(aValue != null ? aValue.toString() : ""));
        JSONObject tOptions = new JSONObject();
        tOptions.put("sortValue", (Object)(aSortValue != null ? aSortValue.toString() : ""));
        tObject.put("options", (Object)tOptions);
        return tObject;
    }

    private String generateSeverityField(Severity severity) {
        return "<div style=\"height:24px;margin:-4px;\">\n<div class=\"severity-" + severity.name().toLowerCase() + "-bg text-center pull-left\" style=\"width:24px; height:24px; color:#ffffff\">\n" + this.bugSymbol + "</div>\n<div class=\"text-center pull-left\" style=\"height:24px;\">\n  <div style=\"font-size:12px; padding:4px\"><span class=\"severity-value\">" + this.convert(severity.name()) + "</span></div>\n</div>\n</div>";
    }

    private String generateVulnerabilityField(Vulnerability vulnerability) {
        String source = vulnerability.getSource().name();
        String id = this.escape(vulnerability.getName());
        return "<span class=\"vuln-source vuln-source-" + source.toLowerCase() + "\">" + source + "</span>" + this.escape(id);
    }

    private String convert(String str) {
        char[] ch = str.toCharArray();
        for (int i = 0; i < str.length(); ++i) {
            if (i == 0 && ch[i] != ' ' || ch[i] != ' ' && ch[i - 1] == ' ') {
                if (ch[i] < 'a' || ch[i] > 'z') continue;
                ch[i] = (char)(ch[i] - 97 + 65);
                continue;
            }
            if (ch[i] < 'A' || ch[i] > 'Z') continue;
            ch[i] = (char)(ch[i] + 97 - 65);
        }
        return new String(ch);
    }
}

