/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck.transformer;

import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.DependencyCheck.model.Dependency;
import org.jenkinsci.plugins.DependencyCheck.model.Finding;
import org.jenkinsci.plugins.DependencyCheck.model.Severity;
import org.jenkinsci.plugins.DependencyCheck.model.Vulnerability;

public class FindingsTransformer {
    public JSONObject transform(List<Finding> findings) {
        JSONArray columns = new JSONArray();
        JSONObject fileName = new JSONObject();
        fileName.put("name", (Object)"dependency.fileName");
        fileName.put("title", (Object)"File Name");
        fileName.put("visible", (Object)true);
        fileName.put("filterable", (Object)true);
        fileName.put("sortValue", (Object)"dependency.fileName");
        columns.add((Object)fileName);
        JSONObject filePath = new JSONObject();
        filePath.put("name", (Object)"dependency.filePath");
        filePath.put("title", (Object)"File Path");
        filePath.put("breakpoints", (Object)"all");
        filePath.put("visible", (Object)true);
        filePath.put("filterable", (Object)false);
        filePath.put("sortValue", (Object)"dependency.filePath");
        columns.add((Object)filePath);
        JSONObject sha1 = new JSONObject();
        sha1.put("name", (Object)"dependency.sha1");
        sha1.put("title", (Object)"SHA-1");
        sha1.put("breakpoints", (Object)"all");
        sha1.put("visible", (Object)true);
        sha1.put("filterable", (Object)true);
        sha1.put("sortValue", (Object)"dependency.sha1");
        columns.add((Object)sha1);
        JSONObject sha256 = new JSONObject();
        sha256.put("name", (Object)"dependency.sha256");
        sha256.put("title", (Object)"SHA-256");
        sha256.put("breakpoints", (Object)"all");
        sha256.put("visible", (Object)true);
        sha256.put("filterable", (Object)true);
        sha256.put("sortValue", (Object)"dependency.sha256");
        columns.add((Object)sha256);
        JSONObject vulnNameLabel = new JSONObject();
        vulnNameLabel.put("name", (Object)"vulnerability.nameLabel");
        vulnNameLabel.put("title", (Object)"Vulnerability");
        vulnNameLabel.put("visible", (Object)true);
        vulnNameLabel.put("filterable", (Object)true);
        vulnNameLabel.put("sortValue", (Object)"vulnerability.name");
        columns.add((Object)vulnNameLabel);
        JSONObject severityLabel = new JSONObject();
        severityLabel.put("name", (Object)"vulnerability.severityLabel");
        severityLabel.put("title", (Object)"Severity");
        severityLabel.put("visible", (Object)true);
        severityLabel.put("filterable", (Object)true);
        severityLabel.put("sortValue", (Object)"vulnerability.severityRank");
        columns.add((Object)severityLabel);
        JSONObject cwe = new JSONObject();
        cwe.put("name", (Object)"vulnerability.cwe");
        cwe.put("title", (Object)"Weakness");
        cwe.put("visible", (Object)true);
        cwe.put("filterable", (Object)true);
        cwe.put("sortValue", (Object)"vulnerability.cwe");
        columns.add((Object)cwe);
        JSONObject vulnDescription = new JSONObject();
        vulnDescription.put("name", (Object)"vulnerability.description");
        vulnDescription.put("title", (Object)"Description");
        vulnDescription.put("breakpoints", (Object)"all");
        vulnDescription.put("visible", (Object)true);
        vulnDescription.put("filterable", (Object)false);
        columns.add((Object)vulnDescription);
        JSONArray rows = new JSONArray();
        for (Finding finding : findings) {
            Dependency dependency = finding.getDependency();
            Vulnerability vulnerability = finding.getVulnerability();
            JSONObject row = new JSONObject();
            row.put("dependency.fileName", (Object)dependency.getFileName());
            row.put("dependency.filePath", (Object)dependency.getFilePath());
            row.put("dependency.description", (Object)dependency.getDescription());
            row.put("dependency.license", (Object)dependency.getLicense());
            row.put("dependency.md5", (Object)dependency.getMd5());
            row.put("dependency.sha1", (Object)dependency.getSha1());
            row.put("dependency.sha256", (Object)dependency.getSha256());
            row.put("vulnerability.source", (Object)vulnerability.getSource());
            row.put("vulnerability.name", (Object)vulnerability.getName());
            row.put("vulnerability.nameLabel", (Object)this.generateVulnerabilityField(vulnerability.getSource().name(), vulnerability.getName()));
            row.put("vulnerability.description", (Object)vulnerability.getDescription());
            row.put("vulnerability.severityLabel", (Object)this.generateSeverityField(Severity.normalize(vulnerability.getSeverity())));
            row.put("vulnerability.severity", (Object)vulnerability.getSeverity());
            row.put("vulnerability.severityRank", (Object)Severity.normalize(vulnerability.getSeverity()).ordinal());
            if (vulnerability.getCwes() != null && !vulnerability.getCwes().isEmpty()) {
                row.put("vulnerability.cwe", (Object)vulnerability.getCwes().get(0));
            }
            rows.add((Object)row);
        }
        JSONObject data = new JSONObject();
        data.put("columns", (Object)columns);
        data.put("rows", (Object)rows);
        return data;
    }

    private String generateSeverityField(Severity severity) {
        return "<div style=\"height:24px;margin:-4px;\">\n<div class=\"severity-" + severity.name().toLowerCase() + "-bg text-center pull-left\" style=\"width:24px; height:24px; color:#ffffff\">\n  <i class=\"fa fa-bug\" style=\"font-size:12px; padding:6px\" aria-hidden=\"true\"></i>\n</div>\n<div class=\"text-center pull-left\" style=\"height:24px;\">\n  <div style=\"font-size:12px; padding:4px\"><span class=\"severity-value\">" + this.convert(severity.name()) + "</span></div>\n</div>\n</div>";
    }

    private String generateVulnerabilityField(String source, String vulnId) {
        return "<span class=\"vuln-source vuln-source-" + source.toLowerCase() + "\">" + source + "</span>" + vulnId;
    }

    private String generateTruncatedStringField(String in) {
        if (in == null) {
            return null;
        }
        return "<div class=\"truncate-ellipsis\"><span>" + in + "</span></div>";
    }

    private String convert(String str) {
        char[] ch = str.toCharArray();
        for (int i = 0; i < str.length(); ++i) {
            if (i == 0 && ch[i] != ' ' || ch[i] != ' ' && ch[i - 1] == ' ') {
                if (ch[i] < 'a' || ch[i] > 'z') continue;
                ch[i] = (char)(ch[i] - 97 + 65);
                continue;
            }
            if (ch[i] < 'A' || ch[i] > 'Z') continue;
            ch[i] = (char)(ch[i] + 97 - 65);
        }
        return new String(ch);
    }
}

