/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck.tools;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.DependencyCheck.DependencyCheckToolBuilder;
import org.jenkinsci.plugins.DependencyCheck.tools.DependencyCheckInstaller;
import org.kohsuke.stapler.DataBoundConstructor;

public class DependencyCheckInstallation
extends ToolInstallation
implements EnvironmentSpecific<DependencyCheckInstallation>,
NodeSpecific<DependencyCheckInstallation>,
Serializable {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public DependencyCheckInstallation(@Nonnull String name, @Nonnull String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public DependencyCheckInstallation forEnvironment(EnvVars environment) {
        return new DependencyCheckInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
    }

    public DependencyCheckInstallation forNode(@Nonnull Node node, TaskListener log) throws IOException, InterruptedException {
        return new DependencyCheckInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
    }

    public String getExecutable(@Nonnull Launcher launcher) throws IOException, InterruptedException {
        VirtualChannel channel = launcher.getChannel();
        return channel == null ? null : (String)channel.call((Callable)new FindExecutableCallable(this.getHome()));
    }

    @Extension
    @Symbol(value={"dependency-check"})
    public static class DescriptorImpl
    extends ToolDescriptor<DependencyCheckInstallation> {
        @Nonnull
        public String getDisplayName() {
            return "Dependency-Check";
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return Collections.singletonList(new DependencyCheckInstaller(null));
        }

        public DependencyCheckInstallation[] getInstallations() {
            Jenkins instance = Jenkins.getInstanceOrNull();
            if (instance == null) {
                return new DependencyCheckInstallation[0];
            }
            return ((DependencyCheckToolBuilder.DependencyCheckToolBuilderDescriptor)instance.getDescriptorByType(DependencyCheckToolBuilder.DependencyCheckToolBuilderDescriptor.class)).getInstallations();
        }

        public void setInstallations(DependencyCheckInstallation ... installations) {
            Jenkins instance = Jenkins.getInstanceOrNull();
            if (instance != null) {
                ((DependencyCheckToolBuilder.DependencyCheckToolBuilderDescriptor)instance.getDescriptorByType(DependencyCheckToolBuilder.DependencyCheckToolBuilderDescriptor.class)).setInstallations(installations);
            }
        }
    }

    private static class FindExecutableCallable
    extends MasterToSlaveCallable<String, IOException> {
        private static final long serialVersionUID = 1L;
        private final String home;

        FindExecutableCallable(String home) {
            this.home = home;
        }

        public String call() throws IOException {
            String arch = ((String)System.getProperties().get("os.name")).toLowerCase(Locale.ENGLISH);
            String command = arch.contains("windows") ? "dependency-check.bat" : "dependency-check.sh";
            return this.home + File.separator + "bin" + File.separator + command;
        }
    }
}

