/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck.model;

import hudson.model.Result;
import java.io.Serializable;
import java.util.List;
import org.jenkinsci.plugins.DependencyCheck.model.Finding;
import org.jenkinsci.plugins.DependencyCheck.model.SeverityDistribution;
import org.jenkinsci.plugins.DependencyCheck.model.Thresholds;

public class RiskGate
implements Serializable {
    private static final long serialVersionUID = 171256230735670985L;
    private Thresholds thresholds;

    public RiskGate(Thresholds thresholds) {
        this.thresholds = thresholds;
    }

    public Result evaluate(SeverityDistribution previousDistribution, List<Finding> previousFindings, SeverityDistribution currentDistribution, List<Finding> currentFindings) {
        Result result = Result.SUCCESS;
        if (currentDistribution != null) {
            if (this.thresholds.totalFindings.failedCritical != null && currentDistribution.getCritical() > 0 && currentDistribution.getCritical() >= this.thresholds.totalFindings.failedCritical || this.thresholds.totalFindings.failedHigh != null && currentDistribution.getHigh() > 0 && currentDistribution.getHigh() >= this.thresholds.totalFindings.failedHigh || this.thresholds.totalFindings.failedMedium != null && currentDistribution.getMedium() > 0 && currentDistribution.getMedium() >= this.thresholds.totalFindings.failedMedium || this.thresholds.totalFindings.failedLow != null && currentDistribution.getLow() > 0 && currentDistribution.getLow() >= this.thresholds.totalFindings.failedLow) {
                return Result.FAILURE;
            }
            if (this.thresholds.totalFindings.unstableCritical != null && currentDistribution.getCritical() > 0 && currentDistribution.getCritical() >= this.thresholds.totalFindings.unstableCritical || this.thresholds.totalFindings.unstableHigh != null && currentDistribution.getHigh() > 0 && currentDistribution.getHigh() >= this.thresholds.totalFindings.unstableHigh || this.thresholds.totalFindings.unstableMedium != null && currentDistribution.getMedium() > 0 && currentDistribution.getMedium() >= this.thresholds.totalFindings.unstableMedium || this.thresholds.totalFindings.unstableLow != null && currentDistribution.getLow() > 0 && currentDistribution.getLow() >= this.thresholds.totalFindings.unstableLow) {
                result = Result.UNSTABLE;
            }
        }
        if (currentDistribution != null && previousDistribution != null) {
            if (this.thresholds.newFindings.failedCritical != null && currentDistribution.getCritical() > 0 && currentDistribution.getCritical() >= previousDistribution.getCritical() + this.thresholds.newFindings.failedCritical || this.thresholds.newFindings.failedHigh != null && currentDistribution.getHigh() > 0 && currentDistribution.getHigh() >= previousDistribution.getHigh() + this.thresholds.newFindings.failedHigh || this.thresholds.newFindings.failedMedium != null && currentDistribution.getMedium() > 0 && currentDistribution.getMedium() >= previousDistribution.getMedium() + this.thresholds.newFindings.failedMedium || this.thresholds.newFindings.failedLow != null && currentDistribution.getLow() > 0 && currentDistribution.getLow() >= previousDistribution.getLow() + this.thresholds.newFindings.failedLow) {
                return Result.FAILURE;
            }
            if (this.thresholds.newFindings.unstableCritical != null && currentDistribution.getCritical() > 0 && currentDistribution.getCritical() >= previousDistribution.getCritical() + this.thresholds.newFindings.unstableCritical || this.thresholds.newFindings.unstableHigh != null && currentDistribution.getHigh() > 0 && currentDistribution.getHigh() >= previousDistribution.getHigh() + this.thresholds.newFindings.unstableHigh || this.thresholds.newFindings.unstableMedium != null && currentDistribution.getMedium() > 0 && currentDistribution.getMedium() >= previousDistribution.getMedium() + this.thresholds.newFindings.unstableMedium || this.thresholds.newFindings.unstableLow != null && currentDistribution.getLow() > 0 && currentDistribution.getLow() >= previousDistribution.getLow() + this.thresholds.newFindings.unstableLow) {
                result = Result.UNSTABLE;
            }
        }
        return result;
    }
}

