/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck.model;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.ObjectCreationFactory;
import org.jenkinsci.plugins.DependencyCheck.model.Analysis;
import org.jenkinsci.plugins.DependencyCheck.model.CvssV2;
import org.jenkinsci.plugins.DependencyCheck.model.CvssV3;
import org.jenkinsci.plugins.DependencyCheck.model.Dependency;
import org.jenkinsci.plugins.DependencyCheck.model.Finding;
import org.jenkinsci.plugins.DependencyCheck.model.ProjectInfo;
import org.jenkinsci.plugins.DependencyCheck.model.Reference;
import org.jenkinsci.plugins.DependencyCheck.model.ReportParserException;
import org.jenkinsci.plugins.DependencyCheck.model.ScanInfo;
import org.jenkinsci.plugins.DependencyCheck.model.Severity;
import org.jenkinsci.plugins.DependencyCheck.model.SeverityDistribution;
import org.jenkinsci.plugins.DependencyCheck.model.Vulnerability;
import org.jenkinsci.plugins.DependencyCheck.model.VulnerabilityCreationFactory;
import org.xml.sax.SAXException;

public class ReportParser {
    private SeverityDistribution severityDistribution;

    public ReportParser(int buildNumber) {
        this.severityDistribution = new SeverityDistribution(buildNumber);
    }

    public List<Finding> parse(InputStream file) throws InvocationTargetException, ReportParserException {
        try {
            Digester digester = new Digester();
            digester.setValidating(false);
            digester.setClassLoader(ReportParser.class.getClassLoader());
            digester.addObjectCreate("analysis", Analysis.class);
            String scanInfoXpath = "analysis/scanInfo";
            digester.addObjectCreate("analysis/scanInfo", ScanInfo.class);
            digester.addBeanPropertySetter("analysis/scanInfo/engineVersion");
            String projectInfoXpath = "analysis/projectInfo";
            digester.addObjectCreate("analysis/projectInfo", ProjectInfo.class);
            digester.addBeanPropertySetter("analysis/projectInfo/name");
            digester.addBeanPropertySetter("analysis/projectInfo/reportDate");
            digester.addBeanPropertySetter("analysis/projectInfo/credits");
            String depXpath = "analysis/dependencies/dependency";
            digester.addObjectCreate("analysis/dependencies/dependency", Dependency.class);
            digester.addBeanPropertySetter("analysis/dependencies/dependency/fileName");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/filePath");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/md5");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/sha1");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/sha256");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/description");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/license");
            String vulnXpath = "analysis/dependencies/dependency/vulnerabilities/vulnerability";
            digester.addFactoryCreate("analysis/dependencies/dependency/vulnerabilities/vulnerability", (ObjectCreationFactory)new VulnerabilityCreationFactory());
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/name");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/description");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/severity");
            String cwesXpath = "analysis/dependencies/dependency/vulnerabilities/vulnerability/cwes";
            digester.addObjectCreate("analysis/dependencies/dependency/vulnerabilities/vulnerability/cwes", ArrayList.class);
            digester.addCallMethod("analysis/dependencies/dependency/vulnerabilities/vulnerability/cwes/cwe", "add", 1);
            digester.addCallParam("analysis/dependencies/dependency/vulnerabilities/vulnerability/cwes/cwe", 0);
            String cvssV2Xpath = "analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV2";
            digester.addObjectCreate("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV2", CvssV2.class);
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV2/score");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV2/accessVector");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV2/accessComplexity");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV2/authenticationr");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV2/confidentialImpact");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV2/integrityImpact");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV2/availabilityImpact");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV2/severity");
            String cvssV3Xpath = "analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV3";
            digester.addObjectCreate("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV3", CvssV3.class);
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV3/baseScore");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV3/attackVector");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV3/attackComplexity");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV3/privilegesRequired");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV3/userInteraction");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV3/scope");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV3/confidentialityImpact");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV3/integrityImpact");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV3/availabilityImpact");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV3/baseSeverity");
            String refXpath = "analysis/dependencies/dependency/vulnerabilities/vulnerability/references/reference";
            digester.addObjectCreate("analysis/dependencies/dependency/vulnerabilities/vulnerability/references/reference", Reference.class);
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/references/reference/source");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/references/reference/url");
            digester.addBeanPropertySetter("analysis/dependencies/dependency/vulnerabilities/vulnerability/references/reference/name");
            digester.addSetNext("analysis/scanInfo", "setScanInfo");
            digester.addSetNext("analysis/projectInfo", "setProjectInfo");
            digester.addSetNext("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV2", "setCvssV2");
            digester.addSetNext("analysis/dependencies/dependency/vulnerabilities/vulnerability/cvssV3", "setCvssV3");
            digester.addSetNext("analysis/dependencies/dependency/vulnerabilities/vulnerability/references/reference", "addReference");
            digester.addSetNext("analysis/dependencies/dependency/vulnerabilities/vulnerability", "addVulnerability");
            digester.addSetNext("analysis/dependencies/dependency/vulnerabilities/vulnerability/cwes", "setCwes");
            digester.addSetNext("analysis/dependencies/dependency", "addDependency");
            Analysis analysis = (Analysis)digester.parse(file);
            if (analysis == null) {
                throw new SAXException("Input stream is not a Dependency-Check report file.");
            }
            if (analysis.getScanInfo() == null || analysis.getScanInfo().getEngineVersion() == null || analysis.getScanInfo().getEngineVersion().startsWith("1") || analysis.getScanInfo().getEngineVersion().startsWith("2") || analysis.getScanInfo().getEngineVersion().startsWith("3") || analysis.getScanInfo().getEngineVersion().startsWith("4")) {
                throw new ReportParserException("Unsupported Dependency-Check schema version detected");
            }
            return this.convert(analysis);
        }
        catch (IOException | SAXException e) {
            throw new InvocationTargetException(e);
        }
    }

    private List<Finding> convert(Analysis collection) {
        ArrayList<Finding> findings = new ArrayList<Finding>();
        for (Dependency dependency : collection.getDependencies()) {
            for (Vulnerability vulnerability : dependency.getVulnerabilities()) {
                Finding finding = new Finding(dependency, vulnerability);
                this.severityDistribution.add(Severity.normalize(vulnerability.getSeverity()));
                findings.add(finding);
            }
        }
        return findings;
    }

    public SeverityDistribution getSeverityDistribution() {
        return this.severityDistribution;
    }
}

