/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck;

import hudson.model.Action;
import hudson.model.Run;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.jenkinsci.plugins.DependencyCheck.JobAction;
import org.jenkinsci.plugins.DependencyCheck.model.Finding;
import org.jenkinsci.plugins.DependencyCheck.model.SeverityDistribution;
import org.jenkinsci.plugins.DependencyCheck.transformer.FindingsTransformer;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class ResultAction
implements RunAction2,
SimpleBuildStep.LastBuildAction {
    private transient Run<?, ?> run;
    private List<Finding> findings;
    private SeverityDistribution severityDistribution;

    public ResultAction(Run<?, ?> build, List<Finding> findings, SeverityDistribution severityDistribution) {
        this.findings = findings;
        this.severityDistribution = severityDistribution;
    }

    public String getIconFileName() {
        return "/plugin/dependency-check-jenkins-plugin/icons/dependency-check-icon.svg";
    }

    public String getDisplayName() {
        return "Dependency-Check";
    }

    public String getUrlName() {
        return "dependency-check-findings";
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new JobAction(this.run.getParent()));
    }

    public Run getRun() {
        return this.run;
    }

    public SeverityDistribution getSeverityDistribution() {
        return this.severityDistribution;
    }

    public List<Finding> getFindings() {
        return this.findings;
    }

    @JavaScriptMethod
    public JSONObject getFindingsJson() {
        FindingsTransformer transformer = new FindingsTransformer();
        return transformer.transform(this.findings);
    }

    @JavaScriptMethod
    public JSONObject getSeverityDistributionJson() {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setExcludes(new String[]{"buildNumber"});
        return JSONObject.fromObject((Object)this.severityDistribution, (JsonConfig)jsonConfig);
    }
}

