/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck;

import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.util.RunList;
import java.util.ArrayList;
import net.sf.json.JSONArray;
import org.jenkinsci.plugins.DependencyCheck.ResultAction;
import org.jenkinsci.plugins.DependencyCheck.model.SeverityDistribution;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class JobAction
implements Action {
    private Job<?, ?> project;

    public JobAction(Job<?, ?> project) {
        this.project = project;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "odcTrend";
    }

    public Job<?, ?> getProject() {
        return this.project;
    }

    public boolean isTrendVisible() {
        RunList builds = this.project.getBuilds();
        int count = 0;
        for (Run currentBuild : builds) {
            ResultAction action = (ResultAction)currentBuild.getAction(ResultAction.class);
            if (action != null) {
                return true;
            }
            if (++count != 10) continue;
            break;
        }
        return false;
    }

    @JavaScriptMethod
    public JSONArray getSeverityDistributionTrend() {
        ArrayList<SeverityDistribution> severityDistributions = new ArrayList<SeverityDistribution>();
        RunList builds = this.project.getBuilds();
        int count = 0;
        for (Run currentBuild : builds) {
            ResultAction action = (ResultAction)currentBuild.getAction(ResultAction.class);
            if (action != null && action.getSeverityDistribution() != null) {
                severityDistributions.add(action.getSeverityDistribution());
            }
            if (++count != 10) continue;
            break;
        }
        return JSONArray.fromObject(severityDistributions);
    }
}

