/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.triggers.SCMTrigger;
import hudson.util.ArgumentListBuilder;
import hudson.util.QuotedStringTokenizer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.DependencyCheck.ConsoleLogger;
import org.jenkinsci.plugins.DependencyCheck.Messages;
import org.jenkinsci.plugins.DependencyCheck.tools.DependencyCheckInstallation;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DependencyCheckToolBuilder
extends Builder
implements SimpleBuildStep,
Serializable {
    private String odcInstallation;
    private String additionalArguments;
    private boolean skipOnScmChange;
    private boolean skipOnUpstreamChange;

    @DataBoundConstructor
    public DependencyCheckToolBuilder() {
    }

    public String getOdcInstallation() {
        return this.odcInstallation;
    }

    @DataBoundSetter
    public void setOdcInstallation(String odcInstallation) {
        this.odcInstallation = odcInstallation;
    }

    public String getAdditionalArguments() {
        return this.additionalArguments;
    }

    @DataBoundSetter
    public void setAdditionalArguments(String additionalArguments) {
        this.additionalArguments = additionalArguments;
    }

    public boolean isSkipOnScmChange() {
        return this.skipOnScmChange;
    }

    @DataBoundSetter
    public void setSkipOnScmChange(boolean skipOnScmChange) {
        this.skipOnScmChange = skipOnScmChange;
    }

    public boolean isSkipOnUpstreamChange() {
        return this.skipOnUpstreamChange;
    }

    @DataBoundSetter
    public void setSkipOnUpstreamChange(boolean skipOnUpstreamChange) {
        this.skipOnUpstreamChange = skipOnUpstreamChange;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        Node node;
        ConsoleLogger logger = new ConsoleLogger(listener);
        if (this.isSkip(build, listener, logger)) {
            build.setResult(Result.SUCCESS);
            return;
        }
        EnvVars env = build.getEnvironment(listener);
        DependencyCheckInstallation installation = this.findInstallation();
        if (installation == null) {
            logger.log(Messages.Builder_InstallationNotSpecified());
            build.setResult(Result.FAILURE);
            return;
        }
        Computer computer = workspace.toComputer();
        Node node2 = node = computer != null ? computer.getNode() : null;
        if (node == null) {
            logger.log(Messages.Builder_InvalidNode());
            build.setResult(Result.FAILURE);
            return;
        }
        installation = installation.forNode(node, listener);
        String odcScript = (installation = installation.forEnvironment(env)).getExecutable(launcher);
        if (odcScript == null) {
            logger.log(Messages.Builder_NoWrapperScript());
            build.setResult(Result.FAILURE);
            return;
        }
        ArgumentListBuilder cliArguments = this.buildArgumentList(odcScript, build, workspace, env);
        int exitCode = launcher.launch().cmds(cliArguments).envs((Map)env).stdout((OutputStream)((Object)logger)).quiet(true).pwd(workspace).join();
        boolean success = exitCode == 0;
        build.setResult(success ? Result.SUCCESS : Result.FAILURE);
    }

    private ArgumentListBuilder buildArgumentList(@Nonnull String odcScript, @Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull EnvVars env) {
        ArgumentListBuilder cliArguments = new ArgumentListBuilder(new String[]{odcScript});
        if (!this.additionalArguments.contains("--project")) {
            cliArguments.add(new String[]{"--project", build.getFullDisplayName()});
        }
        if (!this.additionalArguments.contains("--scan") && !this.additionalArguments.contains("-s ")) {
            cliArguments.add(new String[]{"--scan", workspace.getRemote()});
        }
        if (!this.additionalArguments.contains("--format") && !this.additionalArguments.contains("-f ")) {
            cliArguments.add(new String[]{"--format", "XML"});
        }
        if (Util.fixEmptyAndTrim((String)this.additionalArguments) != null) {
            for (String addArg : QuotedStringTokenizer.tokenize((String)this.additionalArguments)) {
                if (Util.fixEmptyAndTrim((String)addArg) == null) continue;
                cliArguments.add(Util.replaceMacro((String)addArg, (Map)env));
            }
        }
        return cliArguments;
    }

    private DependencyCheckInstallation findInstallation() {
        return Stream.of(((DependencyCheckToolBuilderDescriptor)this.getDescriptor()).getInstallations()).filter(installation -> installation.getName().equals(this.odcInstallation)).findFirst().orElse(null);
    }

    private boolean isSkip(Run<?, ?> build, TaskListener listener, ConsoleLogger logger) {
        boolean skip = false;
        try {
            skip = Boolean.parseBoolean((String)build.getEnvironment(listener).get((Object)"OWASP_DC_SKIP"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List causes = build.getCauses();
        for (Cause cause : causes) {
            if (this.skipOnScmChange && cause instanceof SCMTrigger.SCMTriggerCause) {
                skip = true;
            }
            if (!this.skipOnUpstreamChange || !(cause instanceof Cause.UpstreamCause)) continue;
            skip = true;
        }
        if (skip) {
            logger.log(Messages.Builder_Skip());
        }
        return skip;
    }

    @Extension
    @Symbol(value={"dependencyCheck", "dependencycheck"})
    public static class DependencyCheckToolBuilderDescriptor
    extends BuildStepDescriptor<Builder> {
        private volatile DependencyCheckInstallation[] installations = new DependencyCheckInstallation[0];

        public DependencyCheckToolBuilderDescriptor() {
            this.load();
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.Builder_Name();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public DependencyCheckInstallation[] getInstallations() {
            return this.installations;
        }

        public void setInstallations(DependencyCheckInstallation ... installations) {
            this.installations = installations;
            this.save();
        }

        public boolean hasInstallationsAvailable() {
            return this.installations.length > 0;
        }
    }
}

