/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.DependencyCheck;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.DependencyCheck.ConsoleLogger;
import org.jenkinsci.plugins.DependencyCheck.JobAction;
import org.jenkinsci.plugins.DependencyCheck.Messages;
import org.jenkinsci.plugins.DependencyCheck.ResultAction;
import org.jenkinsci.plugins.DependencyCheck.ThresholdCapablePublisher;
import org.jenkinsci.plugins.DependencyCheck.model.Finding;
import org.jenkinsci.plugins.DependencyCheck.model.ReportParser;
import org.jenkinsci.plugins.DependencyCheck.model.ReportParserException;
import org.jenkinsci.plugins.DependencyCheck.model.RiskGate;
import org.jenkinsci.plugins.DependencyCheck.model.SeverityDistribution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DependencyCheckPublisher
extends ThresholdCapablePublisher
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 921545548328565547L;
    private static final String DEFAULT_PATTERN = "**/dependency-check-report.xml";
    private String pattern;

    @DataBoundConstructor
    public DependencyCheckPublisher() {
    }

    public String getPattern() {
        return this.pattern;
    }

    @DataBoundSetter
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        FilePath[] odcReportFiles;
        ConsoleLogger logger = new ConsoleLogger(listener);
        logger.log(Messages.Publisher_CollectingArtifact());
        if (StringUtils.isBlank((CharSequence)this.pattern)) {
            this.pattern = DEFAULT_PATTERN;
        }
        if ((odcReportFiles = filePath.list(this.pattern)).length == 0) {
            logger.log(Messages.Publisher_NoArtifactsFound());
            build.setResult(Result.UNSTABLE);
            return;
        }
        ReportParser parser = new ReportParser(build.getNumber());
        for (FilePath odcReportFile : odcReportFiles) {
            try {
                List<Finding> findings = parser.parse(odcReportFile.read());
                SeverityDistribution severityDistribution = parser.getSeverityDistribution();
                ResultAction projectAction = new ResultAction(build, findings, severityDistribution);
                build.addAction((Action)projectAction);
                Run previousBuild = build.getPreviousBuild();
                RiskGate riskGate = new RiskGate(this.getThresholds());
                if (previousBuild != null) {
                    Result result;
                    ResultAction previousResults = (ResultAction)previousBuild.getAction(ResultAction.class);
                    if (previousResults != null) {
                        result = riskGate.evaluate(previousResults.getSeverityDistribution(), previousResults.getFindings(), severityDistribution, findings);
                        this.evaluateRiskGates(build, logger, result);
                        continue;
                    }
                    result = riskGate.evaluate(severityDistribution, new ArrayList<Finding>(), severityDistribution, findings);
                    this.evaluateRiskGates(build, logger, result);
                    continue;
                }
                Result result = riskGate.evaluate(severityDistribution, new ArrayList<Finding>(), severityDistribution, findings);
                this.evaluateRiskGates(build, logger, result);
            }
            catch (InvocationTargetException | ReportParserException e) {
                logger.log(Messages.Publisher_NotParsable() + " " + odcReportFile.getRemote());
                logger.log(e.getMessage());
            }
        }
    }

    private void evaluateRiskGates(Run<?, ?> build, ConsoleLogger logger, Result result) {
        if (Result.SUCCESS != result) {
            logger.log(Messages.Publisher_Threshold_Exceed());
            build.setResult(result);
        }
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new JobAction((Job<?, ?>)project);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    @Symbol(value={"dependencyCheckPublisher"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher>
    implements Serializable {
        private static final long serialVersionUID = -1452897801137670635L;

        public DescriptorImpl() {
            super(DependencyCheckPublisher.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.Publisher_Name();
        }
    }
}

