/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.util;

import com.delphix.dct.ApiClient;
import com.delphix.dct.ApiException;
import com.delphix.dct.Configuration;
import com.delphix.dct.api.JobsApi;
import com.delphix.dct.api.VdbsApi;
import com.delphix.dct.models.DeleteVDBParameters;
import com.delphix.dct.models.DeleteVDBResponse;
import com.delphix.dct.models.Job;
import com.delphix.dct.models.PermissionEnum;
import com.delphix.dct.models.ProvisionVDBBySnapshotParameters;
import com.delphix.dct.models.ProvisionVDBFromBookmarkParameters;
import com.delphix.dct.models.ProvisionVDBResponse;
import com.delphix.dct.models.SearchBody;
import com.delphix.dct.models.SearchVDBsResponse;
import com.delphix.dct.models.VDB;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.delphix.DelphixGlobalConfiguration;
import io.jenkins.plugins.delphix.Messages;
import io.jenkins.plugins.util.CredentialUtil;

public class DctSdkUtil {
    private ApiClient defaultClient;

    public DctSdkUtil(Run<?, ?> run, TaskListener listener, String credId) {
        String url = DelphixGlobalConfiguration.get().getDctUrl();
        if (url == null) {
            listener.getLogger().println(Messages.DctSDkUtil_Error1());
            return;
        }
        String apiKey = CredentialUtil.getApiKey(credId, run);
        if (apiKey == null) {
            listener.getLogger().println(Messages.DctSDkUtil_Error2(credId));
            return;
        }
        this.defaultClient = Configuration.getDefaultApiClient();
        this.defaultClient.setVerifyingSsl(!DelphixGlobalConfiguration.get().getDisableSsl());
        this.defaultClient.setConnectTimeout(120000);
        this.defaultClient.setReadTimeout(120000);
        this.defaultClient.setWriteTimeout(120000);
        this.defaultClient.setUserAgent("Jenkins-3.2.1");
        this.defaultClient.addDefaultHeader("x-dct-client-name", "Jenkins");
        this.defaultClient.setApiKey(apiKey);
        this.defaultClient.setBasePath(url + "/v3");
    }

    public ApiClient getDefaultClient() {
        return this.defaultClient;
    }

    public ProvisionVDBResponse provisionVdbFromBookmark(ProvisionVDBFromBookmarkParameters provisionVDBFromBookmarkParameters) throws ApiException {
        ProvisionVDBResponse result = null;
        VdbsApi apiInstance = new VdbsApi(this.defaultClient);
        result = apiInstance.provisionVdbFromBookmark(provisionVDBFromBookmarkParameters);
        return result;
    }

    public ProvisionVDBResponse provisionVdbBySnapshot(ProvisionVDBBySnapshotParameters provisionVDBBySnapshotParameters) throws ApiException {
        ProvisionVDBResponse result = null;
        VdbsApi apiInstance = new VdbsApi(this.defaultClient);
        result = apiInstance.provisionVdbBySnapshot(provisionVDBBySnapshotParameters);
        return result;
    }

    public DeleteVDBResponse deleteVdb(String vdbId, Boolean force) throws ApiException {
        VdbsApi apiInstance = new VdbsApi(this.defaultClient);
        DeleteVDBParameters deleteVDBParameters = new DeleteVDBParameters();
        deleteVDBParameters.setForce(force);
        DeleteVDBResponse result = apiInstance.deleteVdb(vdbId, deleteVDBParameters);
        return result;
    }

    public VDB getVDBDetails(String vdbId) throws ApiException {
        VdbsApi apiInstance = new VdbsApi(this.defaultClient);
        VDB result = apiInstance.getVdbById(vdbId);
        return result;
    }

    public Job getJobStatus(String jobId) throws ApiException {
        JobsApi apiInstance = new JobsApi(this.defaultClient);
        Job result = apiInstance.getJobById(jobId);
        return result;
    }

    public SearchVDBsResponse searchVDB(String name) throws ApiException {
        VdbsApi apiInstance = new VdbsApi(this.defaultClient);
        Integer limit = 100;
        String cursor = null;
        String sort = "id";
        PermissionEnum permission = PermissionEnum.fromValue((String)"READ");
        SearchBody searchBody = new SearchBody();
        String filterExpr = "name EQ '" + name + "'";
        searchBody.setFilterExpression(filterExpr);
        SearchVDBsResponse result = apiInstance.searchVdbs(limit, cursor, sort, permission, searchBody);
        return result;
    }
}

