/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.delphix.repos;

import com.fasterxml.jackson.databind.JsonNode;
import io.jenkins.plugins.delphix.DelphixEngine;
import io.jenkins.plugins.delphix.DelphixEngineException;
import io.jenkins.plugins.delphix.SelfServiceRequest;
import io.jenkins.plugins.delphix.objects.SelfServiceContainer;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.apache.http.client.ClientProtocolException;
import org.kohsuke.stapler.DataBoundConstructor;

public class SelfServiceRepository
extends DelphixEngine {
    private static final String PATH_ROOT = "/resources/json/delphix/jetstream/container";

    @DataBoundConstructor
    public SelfServiceRepository(String engineAddress, String engineUsername, String enginePassword) {
        super(engineAddress, engineUsername, enginePassword);
    }

    public SelfServiceRepository(DelphixEngine engine) {
        super(engine);
    }

    public LinkedHashMap<String, SelfServiceContainer> listSelfServices() throws ClientProtocolException, IOException, DelphixEngineException {
        LinkedHashMap<String, SelfServiceContainer> environments = new LinkedHashMap<String, SelfServiceContainer>();
        JsonNode environmentsJson = this.engineGet(PATH_ROOT).get("result");
        for (int i = 0; i < environmentsJson.size(); ++i) {
            JsonNode environmentJson = environmentsJson.get(i);
            SelfServiceContainer environment = SelfServiceContainer.fromJson(environmentJson);
            environments.put(environment.getReference(), environment);
        }
        return environments;
    }

    public SelfServiceContainer get(String containerRef) throws IOException, DelphixEngineException {
        JsonNode result = this.engineGet(String.format("/resources/json/delphix/jetstream/container/%s", containerRef)).get("result");
        SelfServiceContainer container = SelfServiceContainer.fromJson(result);
        return container;
    }

    public JsonNode refresh(String containerRef) throws IOException, DelphixEngineException {
        JsonNode result = this.enginePost(String.format("/resources/json/delphix/jetstream/container/%s/refresh", containerRef), new SelfServiceRequest("JSDataContainerRefreshParameters", false, "").toJson());
        return result;
    }

    public JsonNode restore(String containerRef, String bookmark) throws IOException, DelphixEngineException {
        JsonNode result = this.enginePost(String.format("/resources/json/delphix/jetstream/container/%s/restore", containerRef), new SelfServiceRequest("JSTimelinePointBookmarkInput", false, bookmark).toJson());
        return result;
    }

    public JsonNode reset(String containerRef) throws IOException, DelphixEngineException {
        JsonNode result = this.enginePost(String.format("/resources/json/delphix/jetstream/container/%s/reset", containerRef), new SelfServiceRequest("JSDataContainerResetParameters", false, "").toJson());
        return result;
    }

    public JsonNode enable(String containerRef) throws IOException, DelphixEngineException {
        JsonNode result = this.enginePost(String.format("/resources/json/delphix/jetstream/container/%s/enable", containerRef), "{}");
        return result;
    }

    public JsonNode disable(String containerRef) throws IOException, DelphixEngineException {
        JsonNode result = this.enginePost(String.format("/resources/json/delphix/jetstream/container/%s/disable", containerRef), "{}");
        return result;
    }

    public JsonNode recover(String containerRef) throws IOException, DelphixEngineException {
        JsonNode result = this.enginePost(String.format("/resources/json/delphix/jetstream/container/%s/recover", containerRef), "{}");
        return result;
    }

    public JsonNode undo(String containerRef, String actionRef) throws IOException, DelphixEngineException {
        JsonNode result = this.enginePost(String.format("/resources/json/delphix/jetstream/container/%s/undo", containerRef), new SelfServiceRequest("JSDataContainerUndoParameters", false, actionRef).toJson());
        return result;
    }

    public JsonNode lock(String containerRef, String userRef) throws IOException, DelphixEngineException {
        JsonNode result = this.enginePost(String.format("/resources/json/delphix/jetstream/container/%s/lock", containerRef), new SelfServiceRequest("JSDataContainerLockParameters", false, userRef).toJson());
        return result;
    }

    public JsonNode unlock(String containerRef) throws IOException, DelphixEngineException {
        JsonNode result = this.enginePost(String.format("/resources/json/delphix/jetstream/container/%s/unlock", containerRef), "{}");
        return result;
    }
}

