/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.delphix.repos;

import com.fasterxml.jackson.databind.JsonNode;
import io.jenkins.plugins.delphix.DelphixEngine;
import io.jenkins.plugins.delphix.DelphixEngineException;
import io.jenkins.plugins.delphix.objects.SelfServiceBookmark;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.apache.http.client.ClientProtocolException;
import org.kohsuke.stapler.DataBoundConstructor;

public class SelfServiceBookmarkRepository
extends DelphixEngine {
    private static final String PATH_ROOT = "/resources/json/delphix/jetstream/bookmark";

    @DataBoundConstructor
    public SelfServiceBookmarkRepository(String engineAddress, String engineUsername, String enginePassword) {
        super(engineAddress, engineUsername, enginePassword);
    }

    public SelfServiceBookmarkRepository(DelphixEngine engine) {
        super(engine);
    }

    public LinkedHashMap<String, SelfServiceBookmark> listBookmarks() throws ClientProtocolException, IOException, DelphixEngineException {
        LinkedHashMap<String, SelfServiceBookmark> bookmarks = new LinkedHashMap<String, SelfServiceBookmark>();
        JsonNode bookmarksJson = this.list();
        for (int i = 0; i < bookmarksJson.size(); ++i) {
            JsonNode bookmarkJson = bookmarksJson.get(i);
            SelfServiceBookmark bookmark = SelfServiceBookmark.fromJson(bookmarkJson);
            bookmarks.put(bookmark.getReference(), bookmark);
        }
        return bookmarks;
    }

    public JsonNode list() throws IOException, DelphixEngineException {
        JsonNode result = this.engineGet(PATH_ROOT).get("result");
        return result;
    }

    public JsonNode delete(String bookmarkRef) throws IOException, DelphixEngineException {
        JsonNode result = this.enginePost(String.format("/resources/json/delphix/jetstream/bookmark/%s/delete", bookmarkRef), "{}");
        return result;
    }

    public JsonNode create(String name, String branch, String sourceDataLayout) throws IOException, DelphixEngineException {
        String request = "{\"type\": \"JSBookmarkCreateParameters\",\"bookmark\": { \"type\": \"JSBookmark\",\"name\": \"" + name + "\",\"branch\": \"" + branch + "\"},\"timelinePointParameters\": {\"type\": \"JSTimelinePointLatestTimeInput\",\"sourceDataLayout\": \"" + sourceDataLayout + "\"}}";
        JsonNode result = this.enginePost(PATH_ROOT, request);
        return result;
    }

    public JsonNode share(String bookmarkRef) throws IOException, DelphixEngineException {
        JsonNode result = this.enginePost(String.format("/resources/json/delphix/jetstream/bookmark/%s/share", bookmarkRef), "{}");
        return result;
    }

    public JsonNode unshare(String bookmarkRef) throws IOException, DelphixEngineException {
        JsonNode result = this.enginePost(String.format("/resources/json/delphix/jetstream/bookmark/%s/unshare", bookmarkRef), "{}");
        return result;
    }
}

