/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.delphix.repos;

import com.fasterxml.jackson.databind.JsonNode;
import io.jenkins.plugins.delphix.DelphixEngine;
import io.jenkins.plugins.delphix.DelphixEngineException;
import io.jenkins.plugins.delphix.objects.Job;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class JobRepository
extends DelphixEngine {
    private static final String PATH_ROOT = "/resources/json/delphix/job";

    @DataBoundConstructor
    public JobRepository(String engineAddress, String engineUsername, String enginePassword) {
        super(engineAddress, engineUsername, enginePassword);
    }

    public JobRepository(DelphixEngine engine) {
        super(engine);
    }

    public void cancel(String jobRef) throws IOException, DelphixEngineException {
        this.enginePost(String.format("/resources/json/delphix/job/%s/cancel", jobRef), "{}");
    }

    public Job get(String jobRef) throws IOException, DelphixEngineException {
        JsonNode result = this.engineGet(String.format("/resources/json/delphix/job/%s", jobRef));
        JsonNode jobStatus = result.get("result");
        return Job.fromJson(jobStatus);
    }
}

