/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.delphix;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.delphix.DelphixBuilder;
import io.jenkins.plugins.delphix.DelphixEngine;
import io.jenkins.plugins.delphix.DelphixEngineException;
import io.jenkins.plugins.delphix.DelphixProperties;
import io.jenkins.plugins.delphix.GlobalConfiguration;
import io.jenkins.plugins.delphix.Messages;
import io.jenkins.plugins.delphix.SelfServiceDescriptor;
import io.jenkins.plugins.delphix.objects.SelfServiceContainer;
import io.jenkins.plugins.delphix.repos.SelfServiceBookmarkRepository;
import io.jenkins.plugins.delphix.repos.SelfServiceRepository;
import java.io.IOException;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class SelfServiceBookmarkBuilder
extends DelphixBuilder
implements SimpleBuildStep {
    public final String delphixEngine;
    public final String delphixBookmark;
    public final String delphixOperation;
    public final String delphixContainer;
    private boolean saveToProps;
    private boolean loadFromProps;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @DataBoundConstructor
    public SelfServiceBookmarkBuilder(String delphixEngine, String delphixBookmark, String delphixOperation, String delphixContainer) {
        this.delphixEngine = delphixEngine;
        this.delphixOperation = delphixOperation;
        this.delphixBookmark = delphixBookmark;
        this.delphixContainer = delphixContainer;
    }

    public boolean getSaveToProps() {
        return this.saveToProps;
    }

    public boolean getLoadFromProps() {
        return this.loadFromProps;
    }

    @DataBoundSetter
    public void setSaveToProps(boolean saveToProps) {
        this.saveToProps = saveToProps;
    }

    @DataBoundSetter
    public void setLoadFromProps(boolean loadFromProps) {
        this.loadFromProps = loadFromProps;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        if (this.delphixBookmark.equals("NULL")) {
            listener.getLogger().println(Messages.getMessage("invalid.engine.environment"));
        }
        String engine = this.delphixEngine;
        String operationType = this.delphixOperation;
        String container = this.delphixContainer;
        String bookmark = this.delphixBookmark;
        if (GlobalConfiguration.getPluginClassDescriptor().getEngine(engine) == null) {
            listener.getLogger().println(Messages.getMessage("invalid.engine.environment"));
        }
        DelphixProperties delphixProps = new DelphixProperties(workspace, listener);
        if (this.loadFromProps) {
            try {
                container = delphixProps.getContainerReference();
            }
            catch (Throwable t) {
                listener.getLogger().println(t.getMessage());
            }
        }
        if (this.saveToProps) {
            delphixProps.setBookmarkReference(bookmark);
        }
        DelphixEngine loadedEngine = GlobalConfiguration.getPluginClassDescriptor().getEngine(engine);
        SelfServiceBookmarkRepository bookmarkRepo = new SelfServiceBookmarkRepository(loadedEngine);
        SelfServiceRepository containerRepo = new SelfServiceRepository(loadedEngine);
        ObjectNode action = MAPPER.createObjectNode();
        try {
            bookmarkRepo.login();
            switch (operationType) {
                case "Create": {
                    containerRepo.login();
                    SelfServiceContainer containerObj = containerRepo.get(container);
                    String buildName = "Created by Jenkins: Job #" + run.number;
                    action = bookmarkRepo.create(buildName, containerObj.getActiveBranch(), containerObj.getReference());
                    delphixProps.setBookmarkReference(action.get("result").toString());
                    break;
                }
                case "Share": {
                    action = bookmarkRepo.share(bookmark);
                    break;
                }
                case "Unshare": {
                    action = bookmarkRepo.unshare(bookmark);
                    break;
                }
                case "Delete": {
                    action = bookmarkRepo.delete(bookmark);
                    break;
                }
                default: {
                    throw new DelphixEngineException("Undefined Self Service Bookmark Operation");
                }
            }
        }
        catch (DelphixEngineException e) {
            listener.getLogger().println(e.getMessage());
        }
        catch (IOException e) {
            listener.getLogger().println(Messages.getMessage("unable.to.connect", new String[]{bookmarkRepo.getEngineAddress()}));
        }
        if (this.checkActionIsFinished(listener, loadedEngine, (JsonNode)action).booleanValue()) {
            return;
        }
        String job = action.get("job").asText();
        this.checkJobStatus(run, listener, loadedEngine, job, engine, bookmark);
    }

    @Extension
    public static final class RefreshDescriptor
    extends SelfServiceDescriptor {
        @Override
        public ListBoxModel doFillDelphixEngineItems() {
            return super.doFillDelphixEngineItems();
        }

        @Override
        public ListBoxModel doFillDelphixBookmarkItems(@QueryParameter String delphixEngine) {
            return super.doFillDelphixBookmarkItems(delphixEngine);
        }

        public ListBoxModel doFillDelphixContainerItems(@QueryParameter String delphixEngine) {
            return super.doFillDelphixSelfServiceItems(delphixEngine);
        }

        public ListBoxModel doFillDelphixOperationItems() {
            ListBoxModel operations = new ListBoxModel();
            operations.add("Create", "Create");
            operations.add("Delete", "Delete");
            operations.add("Share", "Share");
            operations.add("Unshare", "Unshare");
            return operations;
        }

        public String getDisplayName() {
            return "Delphix - Self Service Bookmark";
        }
    }
}

