/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.delphix;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import io.jenkins.plugins.delphix.DelphixEngineException;
import io.jenkins.plugins.delphix.GlobalConfiguration;
import io.jenkins.plugins.delphix.Messages;
import io.jenkins.plugins.delphix.repos.JobRepository;
import java.io.IOException;
import java.util.Map;

@Extension
public class RunListenerImpl
extends RunListener<AbstractBuild<?, ?>> {
    public void onCompleted(AbstractBuild<?, ?> build, TaskListener listener) {
        try {
            if (build.getResult() == Result.ABORTED) {
                for (Map.Entry jobEngine : build.getEnvironment(listener).entrySet()) {
                    if (!((String)jobEngine.getKey()).contains("JOB-")) continue;
                    JobRepository jobRepo = new JobRepository(GlobalConfiguration.getPluginClassDescriptor().getEngine((String)jobEngine.getValue()));
                    jobRepo.login();
                    jobRepo.cancel((String)jobEngine.getKey());
                    listener.getLogger().println(Messages.getMessage("canceled.job", new String[]{(String)jobEngine.getValue()}));
                }
            }
        }
        catch (DelphixEngineException | IOException | InterruptedException e) {
            listener.getLogger().println(Messages.getMessage("cancel.job.fail"));
        }
        super.onCompleted(build, listener);
    }
}

