/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.database.jpa;

import com.google.common.collect.MapMaker;
import hudson.Extension;
import hudson.model.TopLevelItem;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.sql.DataSource;
import jenkins.model.Jenkins;
import org.hibernate.jpa.HibernatePersistenceProvider;
import org.jenkinsci.plugins.database.Database;
import org.jenkinsci.plugins.database.GlobalDatabaseConfiguration;
import org.jenkinsci.plugins.database.PerItemDatabase;
import org.jenkinsci.plugins.database.PerItemDatabaseConfiguration;
import org.jenkinsci.plugins.database.jpa.GlobalTable;
import org.jenkinsci.plugins.database.jpa.PerItemTable;
import org.jenkinsci.plugins.database.jpa.PersistenceUnitInfoImpl;
import org.jvnet.hudson.annotation_indexer.Index;

@Extension
public class PersistenceService {
    @Inject
    private Jenkins jenkins;
    @Inject
    GlobalDatabaseConfiguration globalDatabaseConfiguration;
    @Inject
    PerItemDatabaseConfiguration perItemDatabaseConfiguration;
    private final AtomicReference<EMFCache<Database>> globalCache = new AtomicReference();
    private final ConcurrentMap<TopLevelItem, EMFCache<PerItemDatabase>> perItemCache = new MapMaker().weakKeys().makeMap();

    public EntityManagerFactory createEntityManagerFactory(DataSource dataSource, List<Class> classes) {
        return new HibernatePersistenceProvider().createContainerEntityManagerFactory((PersistenceUnitInfo)new PersistenceUnitInfoImpl(dataSource, classes, this.jenkins.pluginManager.uberClassLoader), null);
    }

    @CheckForNull
    public EntityManagerFactory getGlobalEntityManagerFactory() throws SQLException, IOException {
        Database db = this.globalDatabaseConfiguration.getDatabase();
        if (db == null) {
            this.close(this.globalCache.getAndSet(null));
            return null;
        }
        EMFCache<Database> c = this.globalCache.get();
        if (c == null || c.cacheKey != db) {
            ArrayList<Class> classes = new ArrayList<Class>();
            for (Class cls : Index.list(GlobalTable.class, (ClassLoader)this.jenkins.pluginManager.uberClassLoader, Class.class)) {
                classes.add(cls);
            }
            c = new EMFCache<Database>(this.createEntityManagerFactory(db.getDataSource(), classes), db);
            this.close(this.globalCache.getAndSet(c));
        }
        return c.factory;
    }

    @CheckForNull
    public EntityManagerFactory getPerItemEntityManagerFactory(TopLevelItem item) throws SQLException, IOException {
        PerItemDatabase db = this.perItemDatabaseConfiguration.getDatabase();
        if (db == null) {
            this.close((EMFCache)this.perItemCache.get(item));
            return null;
        }
        EMFCache<PerItemDatabase> c = (EMFCache<PerItemDatabase>)this.perItemCache.get(item);
        if (c == null || c.cacheKey != db) {
            ArrayList<Class> classes = new ArrayList<Class>();
            for (Class cls : Index.list(PerItemTable.class, (ClassLoader)this.jenkins.pluginManager.uberClassLoader, Class.class)) {
                classes.add(cls);
            }
            c = new EMFCache<PerItemDatabase>(this.createEntityManagerFactory(db.getDataSource(item), classes), db);
            this.close(this.perItemCache.put(item, c));
        }
        return c.factory;
    }

    private void close(EMFCache<?> v) {
        if (v != null) {
            v.factory.close();
        }
    }

    static class EMFCache<K> {
        final K cacheKey;
        final EntityManagerFactory factory;

        EMFCache(EntityManagerFactory factory, K cacheKey) {
            this.factory = factory;
            this.cacheKey = cacheKey;
        }
    }
}

