/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.core;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.view.dashboard.Messages;
import hudson.util.FormValidation;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ImagePortlet
extends DashboardPortlet {
    private String url;

    @DataBoundConstructor
    public ImagePortlet(String name) {
        super(name);
    }

    @Deprecated
    public ImagePortlet(String name, String url) {
        super(name);
        this.url = url;
    }

    public String getImageUrl() {
        return this.url;
    }

    @DataBoundSetter
    public void setImageUrl(String url) {
        this.url = url;
    }

    @Deprecated
    @DataBoundSetter
    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isUrlValid() {
        return ImagePortlet.getUrlError(this.url) == null;
    }

    @CheckForNull
    private static final String getUrlError(String url) {
        if (StringUtils.isBlank((String)url)) {
            return Messages.Dashboard_ImageUrlEmpty();
        }
        try {
            URI allowedUrl = new URI(url);
            String protocol = allowedUrl.getScheme();
            if (!allowedUrl.isAbsolute() || protocol.equals("http") || protocol.equals("https")) {
                return null;
            }
            return Messages.Dashboard_ImageUrlHttp();
        }
        catch (URISyntaxException e) {
            return Messages.Dashboard_ImageUrlInvalid(e.getMessage());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return Messages.Dashboard_Image();
        }

        public FormValidation doCheckImageUrl(@QueryParameter String value) {
            String error = ImagePortlet.getUrlError(value);
            if (error != null) {
                return FormValidation.error((String)error);
            }
            return FormValidation.ok();
        }
    }
}

