/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.stats;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Job;
import hudson.model.TopLevelItem;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.view.dashboard.Messages;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.stapler.DataBoundConstructor;

public class StatJobs
extends DashboardPortlet {
    @DataBoundConstructor
    public StatJobs(String name) {
        super(name);
    }

    public Map<HealthStatus, Integer> getJobStat(List<TopLevelItem> jobs) {
        TreeMap<HealthStatus, Integer> colStatJobs = new TreeMap<HealthStatus, Integer>();
        for (HealthStatus status : HealthStatus.values()) {
            colStatJobs.put(status, 0);
        }
        for (TopLevelItem job : jobs) {
            if (!(job instanceof Job)) continue;
            HealthStatus status = HealthStatus.getHealthStatus((Job)job);
            colStatJobs.put(status, (Integer)colStatJobs.get((Object)status) + 1);
        }
        return colStatJobs;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return Messages.Dashboard_JobStatistics();
        }
    }

    @Deprecated
    public static enum HealthStatus {
        HEALTH_OVER_80("health-80plus.gif", Messages.Dashboard_NoRecentBuildsFailed()),
        HEALTH_60_TO_79("health-60to79.gif", Messages.Dashboard_RecentBuildsFailed("20", "40")),
        HEALTH_40_TO_59("health-40to59.gif", Messages.Dashboard_RecentBuildsFailed("40", "60")),
        HEALTH_20_TO_39("health-20to39.gif", Messages.Dashboard_RecentBuildsFailed("60", "80")),
        HEALTH_0_TO_19("health-00to19.gif", Messages.Dashboard_AllRecentBuildsFailed()),
        HEALTH_UNKNOWN("empty.gif", Messages.Dashboard_UnknownStatus());

        private String iconUrl;
        private String description;

        private HealthStatus(String iconUrl, String description) {
            this.iconUrl = iconUrl;
            this.description = description;
        }

        public static HealthStatus getHealthStatus(Job job) {
            int score = job.getBuildHealth().getScore();
            if (score <= 20) {
                return HEALTH_0_TO_19;
            }
            if (score <= 40) {
                return HEALTH_20_TO_39;
            }
            if (score <= 60) {
                return HEALTH_40_TO_59;
            }
            if (score <= 80) {
                return HEALTH_60_TO_79;
            }
            return job.getFirstBuild() != null ? HEALTH_OVER_80 : HEALTH_UNKNOWN;
        }

        public String getIconUrl() {
            return Hudson.RESOURCE_PATH + "/images/32x32/" + this.iconUrl;
        }

        public String getIconUrl(String size) {
            if (this.iconUrl == null) {
                return Hudson.RESOURCE_PATH + "/images/" + size + "/" + HEALTH_UNKNOWN.getIconUrl();
            }
            if (this.iconUrl.startsWith("/")) {
                return this.iconUrl.replace("/32x32/", "/" + size + "/");
            }
            return Hudson.RESOURCE_PATH + "/images/" + size + "/" + this.iconUrl;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

