/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.view.dashboard.core;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.plugins.view.dashboard.DashboardPortlet;
import hudson.plugins.view.dashboard.Messages;
import hudson.views.JobColumn;
import hudson.views.ListViewColumn;
import hudson.views.StatusColumn;
import hudson.views.WeatherColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import org.kohsuke.stapler.DataBoundConstructor;

public class UnstableJobsPortlet
extends DashboardPortlet {
    private static final Collection<ListViewColumn> COLUMNS = Arrays.asList(new StatusColumn(), new WeatherColumn(), new JobColumn());
    private boolean showOnlyFailedJobs = false;
    private boolean recurse;

    @DataBoundConstructor
    public UnstableJobsPortlet(String name, boolean showOnlyFailedJobs, boolean recurse) {
        super(name);
        this.showOnlyFailedJobs = showOnlyFailedJobs;
        this.recurse = recurse;
    }

    public Collection<Job> getUnstableJobs(Collection<? extends Item> allJobs) {
        ArrayList<Job> unstableJobs = new ArrayList<Job>();
        Result expected = this.showOnlyFailedJobs ? Result.FAILURE : Result.UNSTABLE;
        for (Item item : allJobs) {
            Result result;
            Job job;
            Run run;
            if (!(item instanceof TopLevelItem)) continue;
            if (this.recurse && item instanceof ItemGroup) {
                unstableJobs.addAll(this.getUnstableJobs(((ItemGroup)item).getItems()));
            }
            if (!(item instanceof Job) || (run = (job = (Job)item).getLastCompletedBuild()) == null || (result = run.getResult()) == null || !expected.isBetterOrEqualTo(result)) continue;
            unstableJobs.add(job);
        }
        if (this.recurse) {
            IdentityHashMap duplicates = new IdentityHashMap(unstableJobs.size());
            Iterator<Job> iterator = unstableJobs.iterator();
            while (iterator.hasNext()) {
                Job j = iterator.next();
                if (duplicates.containsKey(j)) {
                    iterator.remove();
                    continue;
                }
                duplicates.put(j, null);
            }
        }
        return unstableJobs;
    }

    public Collection<ListViewColumn> getColumns() {
        return COLUMNS;
    }

    public boolean isShowOnlyFailedJobs() {
        return this.showOnlyFailedJobs;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DashboardPortlet> {
        public String getDisplayName() {
            return Messages.Dashboard_UnstableJobs();
        }
    }
}

