/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.cvs;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.InvisibleAction;
import hudson.model.Queue;
import hudson.model.queue.QueueListener;
import hudson.triggers.SCMTrigger;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class QuietPeriodCompleted
extends InvisibleAction {
    public static String REMOTE_HOSTS = System.getProperty(QuietPeriodCompleted.class.getName() + ".REMOTE_HOSTS");
    public static String REMOTE_NOTE = System.getProperty(QuietPeriodCompleted.class.getName() + ".REMOTE_NOTE");
    public static boolean UPDATE_REPEATS = Boolean.getBoolean(QuietPeriodCompleted.class.getName() + ".UPDATE_REPEATS");
    private final long timestamp = System.currentTimeMillis();

    public long getTimestamp() {
        return this.timestamp;
    }

    public Date getTimestampDate() {
        return new Date(this.timestamp);
    }

    @Extension
    public static class SCMTriggerTimeObserver
    extends QueueListener {
        public void onLeaveWaiting(Queue.WaitingItem wi) {
            Set<String> remoteHosts;
            SCMTrigger.SCMTriggerCause scmCause = null;
            Cause.RemoteCause remoteCause = null;
            if (REMOTE_HOSTS == null) {
                remoteHosts = Collections.emptySet();
            } else {
                remoteHosts = new HashSet<String>();
                for (String host : StringUtils.split((String)REMOTE_HOSTS, (String)", ")) {
                    String h = host.trim();
                    if (StringUtils.isBlank((String)h)) continue;
                    remoteHosts.add(h);
                }
            }
            for (Cause c : wi.getCauses()) {
                if (c instanceof SCMTrigger.SCMTriggerCause) {
                    scmCause = (SCMTrigger.SCMTriggerCause)c;
                    break;
                }
                if (!(c instanceof Cause.RemoteCause)) continue;
                Cause.RemoteCause r = (Cause.RemoteCause)c;
                for (String h : remoteHosts) {
                    if (!new Cause.RemoteCause(h, REMOTE_NOTE).equals((Object)r)) continue;
                    remoteCause = r;
                    break;
                }
                if (remoteCause == null) continue;
                break;
            }
            if (scmCause != null || remoteCause != null) {
                QuietPeriodCompleted existingAction = (QuietPeriodCompleted)wi.getAction(QuietPeriodCompleted.class);
                if (existingAction == null) {
                    wi.addAction((Action)new QuietPeriodCompleted());
                } else if (UPDATE_REPEATS) {
                    wi.getActions().set(wi.getActions().indexOf((Object)existingAction), new QuietPeriodCompleted());
                }
            }
        }
    }
}

