/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.cvstagging;

import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.model.TaskThread;
import hudson.scm.AbstractScmTagAction;
import hudson.scm.CVSSCM;
import hudson.scm.CvsModule;
import hudson.scm.CvsRepository;
import hudson.scm.CvsRepositoryItem;
import hudson.scm.SCM;
import hudson.scm.cvs.Messages;
import hudson.security.Permission;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Expand;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.tag.TagCommand;

public class LegacyTagAction
extends AbstractScmTagAction
implements Describable<LegacyTagAction> {
    private volatile String tagName;
    private CVSSCM parent;

    public LegacyTagAction(Run<?, ?> build, CVSSCM parent) {
        super(build);
        this.parent = parent;
    }

    public String getIconFileName() {
        if (this.tagName == null && !this.build.getParent().getACL().hasPermission(SCM.TAG)) {
            return null;
        }
        return "save.gif";
    }

    public String getDisplayName() {
        if (this.tagName == null) {
            return Messages.CVSSCM_TagThisBuild();
        }
        if (this.tagName.indexOf(32) >= 0) {
            return Messages.CVSSCM_DisplayName2();
        }
        return Messages.CVSSCM_DisplayName1();
    }

    @Exported
    public String[] getTagNames() {
        if (this.tagName == null) {
            return new String[0];
        }
        return this.tagName.split(" ");
    }

    public synchronized FormValidation doCheckTag(@QueryParameter String value) {
        String tag = Util.fixNull((String)value).trim();
        if (tag.length() == 0) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)this.isInvalidTag(tag));
    }

    public Permission getPermission() {
        return SCM.TAG;
    }

    public String getTooltip() {
        if (this.tagName != null) {
            return "Tag: " + this.tagName;
        }
        return null;
    }

    public boolean isTagged() {
        return this.tagName != null;
    }

    @RequirePOST
    public synchronized void doSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.build.checkPermission(this.getPermission());
        HashMap tagSet = new HashMap();
        String name = Util.fixNull((String)req.getParameter("name")).trim();
        String reason = this.isInvalidTag(name);
        if (reason != null) {
            this.sendError(reason, req, rsp);
            return;
        }
        tagSet.put(this.build, name);
        if (req.getParameter("upstream") != null) {
            Enumeration e = req.getParameterNames();
            Map upstreams = this.build.getTransitiveUpstreamBuilds();
            while (e.hasMoreElements()) {
                String upName = (String)e.nextElement();
                if (!upName.startsWith("upstream.")) continue;
                String tag = Util.fixNull((String)req.getParameter(upName)).trim();
                reason = this.isInvalidTag(tag);
                if (reason != null) {
                    this.sendError(Messages.CVSSCM_NoValidTagNameGivenFor(upName, reason), req, rsp);
                    return;
                }
                upName = upName.substring(9);
                AbstractProject p = (AbstractProject)Jenkins.getActiveInstance().getItemByFullName(upName, AbstractProject.class);
                if (p == null) {
                    this.sendError(Messages.CVSSCM_NoSuchJobExists(upName), req, rsp);
                    return;
                }
                Integer buildNum = (Integer)upstreams.get(p);
                if (buildNum == null) {
                    this.sendError(Messages.CVSSCM_NoUpstreamBuildFound(upName), req, rsp);
                    return;
                }
                AbstractBuild build = p.getBuildByNumber(buildNum.intValue());
                tagSet.put(build, tag);
            }
        }
        new LegacyTagWorkerThread(this, tagSet).start();
        this.doIndex(req, rsp);
    }

    private String isInvalidTag(String name) {
        if (name == null || name.length() == 0) {
            return Messages.CVSSCM_TagNameInvalid(Messages.CVSSCM_Tag());
        }
        char ch = name.charAt(0);
        if (!('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z')) {
            return Messages.CVSSCM_TagNameInvalid(Messages.CVSSCM_Tag());
        }
        for (char invalid : "$,.:;@".toCharArray()) {
            if (name.indexOf(invalid) < 0) continue;
            return Messages.CVSSCM_TagNameInvalid(Messages.CVSSCM_Tag());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(String tagName, boolean moveTag, TaskListener listener) {
        File destdir = null;
        try {
            destdir = Util.createTempDir();
            listener.getLogger().println(Messages.CVSSCM_ExpandingWorkspaceArchive(destdir));
            Expand e = new Expand();
            e.setProject(new Project());
            e.setDest(destdir);
            e.setSrc(LegacyTagAction.getArchiveFile(this.build));
            e.setTaskType("unzip");
            e.execute();
            listener.getLogger().println(Messages.CVSSCM_TaggingWorkspace());
            for (CvsRepository repository : this.parent.getRepositories()) {
                for (CvsRepositoryItem item : repository.getRepositoryItems()) {
                    for (CvsModule module : item.getModules()) {
                        Client cvsClient = this.parent.getCvsClient(repository, this.build.getEnvironment(listener), listener);
                        GlobalOptions globalOptions = this.parent.getGlobalOptions(repository, this.build.getEnvironment(listener));
                        File path = new File(destdir, module.getCheckoutName());
                        boolean isDir = path.isDirectory();
                        TagCommand tagCommand = new TagCommand();
                        if (isDir) {
                            tagCommand.setRecursive(true);
                        }
                        tagCommand.setTag(tagName);
                        tagCommand.setOverrideExistingTag(moveTag);
                        if (!isDir) {
                            path = path.getParentFile();
                        }
                        cvsClient.setLocalPath(path.getAbsolutePath());
                        if (!cvsClient.executeCommand((Command)tagCommand, globalOptions)) {
                            listener.getLogger().print(Messages.CVSSCM_TaggingFailed());
                            try {
                                cvsClient.getConnection().close();
                            }
                            catch (IOException ex) {
                                listener.getLogger().println("Could not close client connection: " + ex.getMessage());
                            }
                            return;
                        }
                        try {
                            cvsClient.getConnection().close();
                        }
                        catch (IOException ex) {
                            listener.getLogger().println("Could not close client connection: " + ex.getMessage());
                        }
                    }
                }
            }
            this.onTagCompleted(tagName);
            this.build.save();
        }
        catch (Throwable e) {
            e.printStackTrace(listener.fatalError(e.getMessage()));
        }
        finally {
            try {
                if (destdir != null) {
                    listener.getLogger().println("cleaning up " + destdir);
                    Util.deleteRecursive((File)destdir);
                }
            }
            catch (IOException e) {
                e.printStackTrace(listener.fatalError(e.getMessage()));
            }
        }
    }

    private synchronized void onTagCompleted(String tagName) {
        this.tagName = this.tagName != null ? this.tagName + ' ' + tagName : tagName;
        this.workerThread = null;
    }

    public Descriptor<LegacyTagAction> getDescriptor() {
        return Jenkins.getActiveInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    private static File getArchiveFile(AbstractBuild<?, ?> build) {
        return new File(build.getRootDir(), "workspace.zip");
    }

    @Extension
    public static final class LegacyTagActionDescriptor
    extends Descriptor<LegacyTagAction> {
        public LegacyTagActionDescriptor() {
            super(LegacyTagAction.class);
        }

        public String getDisplayName() {
            return "";
        }
    }

    public static final class LegacyTagWorkerThread
    extends TaskThread {
        private final Map<AbstractBuild<?, ?>, String> tagSet;

        public LegacyTagWorkerThread(LegacyTagAction owner, Map<AbstractBuild<?, ?>, String> tagSet) {
            super((TaskAction)owner, TaskThread.ListenerAndText.forMemory());
            this.tagSet = tagSet;
        }

        public synchronized void start() {
            for (Map.Entry<AbstractBuild<?, ?>, String> e : this.tagSet.entrySet()) {
                LegacyTagAction ta = (LegacyTagAction)e.getKey().getAction(LegacyTagAction.class);
                if (ta == null) continue;
                this.associateWith((TaskAction)ta);
            }
            super.start();
        }

        protected void perform(TaskListener listener) {
            for (Map.Entry<AbstractBuild<?, ?>, String> e : this.tagSet.entrySet()) {
                LegacyTagAction ta = (LegacyTagAction)e.getKey().getAction(LegacyTagAction.class);
                if (ta == null) {
                    listener.error(e.getKey() + " doesn't have CVS tag associated with it. Skipping");
                    continue;
                }
                listener.getLogger().println(Messages.CVSSCM_TagginXasY(e.getKey(), e.getValue()));
                if (e.getKey().hasPermission(Permission.UPDATE)) {
                    try {
                        e.getKey().keepLog();
                    }
                    catch (IOException x) {
                        x.printStackTrace(listener.error(Messages.CVSSCM_FailedToMarkForKeep(e.getKey())));
                    }
                }
                ta.perform(e.getValue(), false, listener);
                listener.getLogger().println();
            }
        }
    }
}

