/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.browsers;

import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.scm.CVSChangeLogSet;
import hudson.scm.CVSRepositoryBrowser;
import hudson.scm.RepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;

public final class OpenGrok
extends CVSRepositoryBrowser {
    private final URL url;

    @DataBoundConstructor
    public OpenGrok(URL url) throws MalformedURLException {
        this.url = OpenGrok.normalizeToEndWithSlash((URL)url);
    }

    @Override
    public URL getFileLink(CVSChangeLogSet.File file) throws IOException {
        return new URL(this.url, file.getName() + this.param().add("r=" + file.getRevision()));
    }

    @Override
    public URL getDiffLink(CVSChangeLogSet.File file) throws IOException {
        CVSChangeLogSet.Revision r = new CVSChangeLogSet.Revision(file.getRevision());
        CVSChangeLogSet.Revision p = r.getPrevious();
        if (p == null) {
            return null;
        }
        String path = this.url.getPath();
        Matcher matches = Pattern.compile("^(.*)/xref/([^/]+/)$").matcher(path);
        if (!matches.matches()) {
            return null;
        }
        String moduleName = matches.group(2);
        path = matches.replaceFirst("$1/diff/" + moduleName);
        path = path + file.getName() + this.param().add("r2=/" + moduleName + file.getName() + "@" + r).add("r1=/" + moduleName + file.getName() + "@" + p);
        return new URL(this.url.getProtocol(), this.url.getHost(), this.url.getPort(), path);
    }

    public URL getChangeSetLink(CVSChangeLogSet.CVSChangeLog changeSet) throws IOException {
        return null;
    }

    private QueryBuilder param() {
        return new QueryBuilder(this.url.getQuery());
    }

    @Exported
    public URL getUrl() {
        return this.url;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        private static final Pattern URL_PATTERN = Pattern.compile("^.+/xref/[^/]+/$");

        public String getDisplayName() {
            return "OpenGrok";
        }

        public FormValidation doCheckUrl(@QueryParameter String value) {
            String url = Util.fixEmpty((String)value);
            if (url == null) {
                return FormValidation.ok();
            }
            if (!url.endsWith("/")) {
                url = url + '/';
            }
            if (!URL_PATTERN.matcher(url).matches()) {
                return FormValidation.errorWithMarkup((String)"The URL should end like <tt>.../xref/foobar/</tt>");
            }
            return FormValidation.ok();
        }
    }
}

