/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm.cvstagging;

import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.scm.AbstractCvs;
import hudson.scm.AbstractScmTagAction;
import hudson.scm.CVSSCM;
import hudson.scm.CvsRevisionState;
import hudson.scm.SCM;
import hudson.scm.cvs.Messages;
import hudson.scm.cvstagging.CvsTagActionWorker;
import hudson.security.Permission;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class CvsTagAction
extends AbstractScmTagAction
implements Describable<CvsTagAction> {
    private final List<String> tagNames = new ArrayList<String>();
    private final AbstractCvs parentScm;
    @Deprecated
    private transient CVSSCM parent;

    public CvsTagAction(Run<?, ?> build, AbstractCvs parent) {
        super(build);
        this.parentScm = parent;
    }

    public Object readResolve() {
        return new CvsTagAction((Run<?, ?>)this.build, this.parent);
    }

    public String getIconFileName() {
        if (!this.build.getParent().getACL().hasPermission(SCM.TAG)) {
            return null;
        }
        return "save.gif";
    }

    public String getDisplayName() {
        if (this.tagNames.isEmpty()) {
            return Messages.CVSSCM_TagThisBuild();
        }
        if (this.tagNames.size() > 1) {
            return Messages.CVSSCM_DisplayName2();
        }
        return Messages.CVSSCM_DisplayName1();
    }

    public boolean isTagged() {
        return !this.tagNames.isEmpty();
    }

    public Descriptor<CvsTagAction> getDescriptor() {
        return Jenkins.getActiveInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Exported
    public String[] getTagNames() {
        return this.tagNames.toArray(new String[this.tagNames.size()]);
    }

    public AbstractCvs getParent() {
        return this.parentScm;
    }

    public synchronized void doSubmit(StaplerRequest request, StaplerResponse response) throws IOException, ServletException {
        this.getBuild().checkPermission(this.getPermission());
        String tagName = Util.fixNull((String)request.getParameter("name")).trim();
        boolean createBranch = Boolean.parseBoolean(request.getParameter("createBranch"));
        if (!this.checkTagName(tagName)) {
            this.sendError(Messages.CVSSCM_TagNameInvalid(Messages.CVSSCM_Tag()));
        }
        boolean moveTag = Boolean.parseBoolean(request.getParameter("moveTag"));
        if (null != request.getParameter("upstream")) {
            Map upstream = this.getBuild().getTransitiveUpstreamBuilds();
            for (AbstractProject project : upstream.keySet()) {
                String upstreamTagName = Util.fixNull((String)request.getParameter("upstream." + project.getName())).trim();
                boolean upstreamCreateBranch = Boolean.parseBoolean(request.getParameter("upstream-createBranch." + project.getName()));
                if (!this.checkTagName(upstreamTagName)) {
                    this.sendError(Messages.CVSSCM_TagNameInvalid(Messages.CVSSCM_Tag()));
                }
                boolean upstreamMoveTag = Boolean.parseBoolean(request.getParameter("upstream-moveTag." + project.getName()));
                CvsTagAction action = (CvsTagAction)project.getBuildByNumber(((Integer)upstream.get(project)).intValue()).getAction(CvsTagAction.class);
                if (null == action) continue;
                action.perform(upstreamTagName, upstreamCreateBranch, upstreamMoveTag);
            }
        }
        this.perform(tagName, createBranch, moveTag);
        this.doIndex(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(String tagName, boolean createTag, boolean moveTag) throws IOException {
        CvsRevisionState state = (CvsRevisionState)this.getBuild().getAction(CvsRevisionState.class);
        if (state == null) {
            return;
        }
        CvsTagActionWorker worker = new CvsTagActionWorker(state, tagName, createTag, this.getBuild(), this, moveTag);
        worker.start();
        if (worker.isSuccess()) {
            if (this.getBuild().hasPermission(Permission.UPDATE)) {
                this.getBuild().keepLog(true);
            }
            CvsTagAction cvsTagAction = this;
            synchronized (cvsTagAction) {
                this.tagNames.add(tagName);
            }
        }
    }

    public FormValidation doCheckTag(@QueryParameter String value) {
        if (this.checkTagName(value)) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)Messages.CVSSCM_TagNameInvalid(Messages.CVSSCM_Tag()));
    }

    public boolean checkTagName(String tagName) {
        if (Util.fixNull((String)tagName).length() == 0) {
            return false;
        }
        char ch = tagName.charAt(0);
        if (!('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z')) {
            return false;
        }
        for (char invalid : "$,.:;@".toCharArray()) {
            if (tagName.indexOf(invalid) < 0) continue;
            return false;
        }
        return true;
    }
}

