/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.adamcin.granite.client.packman.ACHandling;
import net.adamcin.granite.client.packman.PackId;
import net.adamcin.granite.client.packman.WspFilter;
import net.adamcin.granite.client.packman.validation.DefaultValidationOptions;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.graniteclient.AbstractBuildStep;
import org.jenkinsci.plugins.graniteclient.BaseUrlUtil;
import org.jenkinsci.plugins.graniteclient.IdentifyPackageCallable;
import org.jenkinsci.plugins.graniteclient.PathOrPackIdFilter;
import org.jenkinsci.plugins.graniteclient.ValidateFileCallable;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ValidatePackagesBuilder
extends AbstractBuildStep {
    private String packageIdFilters;
    private String localDirectory = null;
    private String validationFilter = null;
    private boolean allowNonCoveredRoots = false;
    private String forbiddenExtensions = null;
    private String forbiddenACHandlingModeSet = null;
    private String forbiddenFilterRootPrefixes = null;
    private String pathsDeniedForInclusion = null;

    @DataBoundConstructor
    public ValidatePackagesBuilder(String packageIdFilters) {
        this.packageIdFilters = packageIdFilters;
    }

    public ValidatePackagesBuilder(String packageIdFilters, String localDirectory, String validationFilter, boolean allowNonCoveredRoots, String forbiddenExtensions, String forbiddenACHandlingModeSet, String forbiddenFilterRootPrefixes, String pathsDeniedForInclusion) {
        this.packageIdFilters = packageIdFilters;
        this.localDirectory = localDirectory;
        this.validationFilter = validationFilter;
        this.allowNonCoveredRoots = allowNonCoveredRoots;
        this.forbiddenExtensions = forbiddenExtensions;
        this.forbiddenACHandlingModeSet = forbiddenACHandlingModeSet;
        this.forbiddenFilterRootPrefixes = forbiddenFilterRootPrefixes;
        this.pathsDeniedForInclusion = pathsDeniedForInclusion;
    }

    public String getPackageIdFilters() {
        if (this.packageIdFilters != null) {
            return this.packageIdFilters.trim();
        }
        return "";
    }

    @DataBoundSetter
    public void setPackageIdFilters(String packageIdFilters) {
        this.packageIdFilters = packageIdFilters;
    }

    public String getLocalDirectory() {
        if (StringUtils.isBlank((String)this.localDirectory)) {
            return ".";
        }
        return this.localDirectory.trim();
    }

    @DataBoundSetter
    public void setLocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }

    public String getValidationFilter() {
        return this.validationFilter == null ? "" : this.validationFilter;
    }

    @DataBoundSetter
    public void setValidationFilter(String validationFilter) {
        this.validationFilter = validationFilter;
    }

    public boolean isAllowNonCoveredRoots() {
        return this.allowNonCoveredRoots;
    }

    @DataBoundSetter
    public void setAllowNonCoveredRoots(boolean allowNonCoveredRoots) {
        this.allowNonCoveredRoots = allowNonCoveredRoots;
    }

    public String getForbiddenExtensions() {
        return this.forbiddenExtensions == null ? "" : this.forbiddenExtensions;
    }

    @DataBoundSetter
    public void setForbiddenExtensions(String forbiddenExtensions) {
        this.forbiddenExtensions = forbiddenExtensions;
    }

    public String getForbiddenACHandlingModeSet() {
        return this.forbiddenACHandlingModeSet == null ? ForbiddenACHandlingModeSet.SKIP_VALIDATION.name() : this.forbiddenACHandlingModeSet;
    }

    @DataBoundSetter
    public void setForbiddenACHandlingModeSet(String forbiddenACHandlingModeSet) {
        this.forbiddenACHandlingModeSet = forbiddenACHandlingModeSet;
    }

    public String getForbiddenFilterRootPrefixes() {
        return this.forbiddenFilterRootPrefixes == null ? "" : this.forbiddenFilterRootPrefixes;
    }

    @DataBoundSetter
    public void setForbiddenFilterRootPrefixes(String forbiddenFilterRootPrefixes) {
        this.forbiddenFilterRootPrefixes = forbiddenFilterRootPrefixes;
    }

    public String getPathsDeniedForInclusion() {
        return this.pathsDeniedForInclusion == null ? "" : this.pathsDeniedForInclusion;
    }

    @DataBoundSetter
    public void setPathsDeniedForInclusion(String pathsDeniedForInclusion) {
        this.pathsDeniedForInclusion = pathsDeniedForInclusion;
    }

    public String getValidationFilter(Run<?, ?> build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        try {
            return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getValidationFilter());
        }
        catch (Exception e) {
            listener.error("failed to expand tokens in: %s%n", new Object[]{this.getValidationFilter()});
            return this.getValidationFilter();
        }
    }

    public String getForbiddenExtensions(Run<?, ?> build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        try {
            return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getForbiddenExtensions());
        }
        catch (Exception e) {
            listener.error("failed to expand tokens in: %s%n", new Object[]{this.getForbiddenExtensions()});
            return this.getForbiddenExtensions();
        }
    }

    public String getPathsDeniedForInclusion(Run<?, ?> build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        try {
            return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getPathsDeniedForInclusion());
        }
        catch (Exception e) {
            listener.error("failed to expand tokens in: %s%n", new Object[]{this.getPathsDeniedForInclusion()});
            return this.getPathsDeniedForInclusion();
        }
    }

    public String getForbiddenFilterRootPrefixes(Run<?, ?> build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        try {
            return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getForbiddenFilterRootPrefixes());
        }
        catch (Exception e) {
            listener.error("failed to expand tokens in: %s%n", new Object[]{this.getForbiddenFilterRootPrefixes()});
            return this.getForbiddenFilterRootPrefixes();
        }
    }

    public List<ACHandling> getForbiddenACHandlingModes() {
        return ForbiddenACHandlingModeSet.safeValueOf(this.getForbiddenACHandlingModeSet()).getForbiddenModes();
    }

    private DefaultValidationOptions getValidationOptions(Run<?, ?> build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        WspFilter filter;
        DefaultValidationOptions options = new DefaultValidationOptions();
        options.setAllowNonCoveredRoots(this.isAllowNonCoveredRoots());
        options.setForbiddenExtensions(Arrays.asList(this.getForbiddenExtensions(build, workspace, listener).split("\r?\n")));
        options.setPathsDeniedForInclusion(Arrays.asList(this.getPathsDeniedForInclusion(build, workspace, listener).split("\r?\n")));
        options.setForbiddenACHandlingModes(this.getForbiddenACHandlingModes());
        options.setForbiddenFilterRootPrefixes(Arrays.asList(this.getForbiddenFilterRootPrefixes(build, workspace, listener).split("\r?\n")));
        String wspFilterString = this.getValidationFilter(build, workspace, listener);
        WspFilter wspFilter = filter = StringUtils.isBlank((String)wspFilterString) ? null : WspFilter.parseSimpleSpec((String)this.getValidationFilter(build, workspace, listener));
        if (filter != null && !filter.getRoots().isEmpty()) {
            options.setValidationFilter(filter);
        }
        return options;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        Result result = build.getResult();
        if (result == null) {
            result = Result.SUCCESS;
        }
        listener.getLogger().println("Validating packages.");
        DefaultValidationOptions options = this.getValidationOptions(build, workspace, listener);
        for (PackTuple selectedPackage : this.selectPackages(build, workspace, listener)) {
            listener.getLogger().printf("Validating package %s at path %s.%n", selectedPackage.getPackId(), selectedPackage.getFilePath());
            ValidateFileCallable callable = new ValidateFileCallable(listener, options);
            result = result.combine((Result)selectedPackage.getFilePath().act((FilePath.FileCallable)callable));
            build.setResult(result);
        }
    }

    private List<PackTuple> selectPackages(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        ArrayList<PackTuple> found = new ArrayList<PackTuple>();
        String fLocalDirectory = this.getLocalDirectory(build, workspace, listener);
        FilePath dir = workspace.child(fLocalDirectory);
        try {
            ArrayList<FilePath> listed = new ArrayList<FilePath>();
            listed.addAll(Arrays.asList(dir.list("**/*.jar")));
            listed.addAll(Arrays.asList(dir.list("**/*.zip")));
            for (FilePath filePath : listed) {
                PackId packId = null;
                try {
                    packId = (PackId)filePath.act((FilePath.FileCallable)new IdentifyPackageCallable());
                }
                catch (Exception e) {
                    listener.error("Failed to identify package file: %s", new Object[]{e.getMessage()});
                }
                found.add(new PackTuple(packId, filePath));
            }
        }
        catch (Exception e) {
            listener.error("Failed to list package files: %s", new Object[]{e.getMessage()});
        }
        ArrayList<PackTuple> selected = new ArrayList<PackTuple>();
        for (Map.Entry entry : this.listPackageFilters(build, workspace, listener).entrySet()) {
            boolean matched = false;
            for (PackTuple entry2 : found) {
                if (!entry2.isPathOnly() && ((PathOrPackIdFilter)entry.getValue()).includes(entry2.getPackId())) {
                    matched = true;
                    selected.add(entry2);
                    continue;
                }
                if (!((PathOrPackIdFilter)entry.getValue()).includes(dir, entry2.getFilePath())) continue;
                matched = true;
                selected.add(entry2);
            }
            if (matched) continue;
            throw new IOException("No package found matching filter " + (String)entry.getKey());
        }
        return Collections.unmodifiableList(selected);
    }

    public String getPackageIdFilters(Run<?, ?> build, FilePath workspace, TaskListener listener) throws Exception {
        return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getPackageIdFilters());
    }

    private Map<String, PathOrPackIdFilter> listPackageFilters(Run<?, ?> build, FilePath workspace, TaskListener listener) {
        LinkedHashMap<String, PathOrPackIdFilter> filters = new LinkedHashMap<String, PathOrPackIdFilter>();
        try {
            for (String filter : BaseUrlUtil.splitByNewline(this.getPackageIdFilters(build, workspace, listener))) {
                if (filter.trim().length() <= 0) continue;
                filters.put(filter, PathOrPackIdFilter.parse(filter));
            }
        }
        catch (Exception e) {
            listener.error("failed to expand tokens in: %n%s", new Object[]{this.getPackageIdFilters()});
        }
        return Collections.unmodifiableMap(filters);
    }

    private String getLocalDirectory(Run<?, ?> build, FilePath workspace, TaskListener listener) {
        try {
            return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getLocalDirectory());
        }
        catch (Exception e) {
            listener.error("failed to expand tokens in: %s%n", new Object[]{this.getLocalDirectory()});
            return this.getLocalDirectory();
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    static enum ForbiddenACHandlingModeSet {
        SKIP_VALIDATION("Skip Validation", Collections.emptyList()),
        NO_CLEAR("No Clear", Collections.singletonList(ACHandling.CLEAR)),
        NO_UNSAFE("No Unsafe", Arrays.asList(ACHandling.CLEAR, ACHandling.OVERWRITE)),
        ALLOW_ADDITIVE("Allow Additive", Arrays.asList(ACHandling.CLEAR, ACHandling.OVERWRITE, ACHandling.MERGE)),
        NO_ACL("No ACLs", Arrays.asList(ACHandling.CLEAR, ACHandling.OVERWRITE, ACHandling.MERGE, ACHandling.MERGE_PRESERVE));

        private final String listLabel;
        private final List<ACHandling> forbiddenModes;

        private ForbiddenACHandlingModeSet(String listLabel, List<ACHandling> forbiddenModes) {
            this.listLabel = listLabel;
            this.forbiddenModes = forbiddenModes;
        }

        public String getListLabel() {
            return this.listLabel;
        }

        public List<ACHandling> getForbiddenModes() {
            return this.forbiddenModes;
        }

        static ForbiddenACHandlingModeSet forEmptySelection() {
            return SKIP_VALIDATION;
        }

        static ForbiddenACHandlingModeSet forUnknownSelection() {
            return NO_ACL;
        }

        static ForbiddenACHandlingModeSet safeValueOf(String modeSetName) {
            if (StringUtils.isEmpty((String)modeSetName)) {
                return ForbiddenACHandlingModeSet.forEmptySelection();
            }
            try {
                return ForbiddenACHandlingModeSet.valueOf(modeSetName);
            }
            catch (IllegalArgumentException e) {
                if (modeSetName.toLowerCase().startsWith("skip")) {
                    return ForbiddenACHandlingModeSet.forEmptySelection();
                }
                return ForbiddenACHandlingModeSet.forUnknownSelection();
            }
        }
    }

    @Symbol(value={"crxValidate"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public static final String ACMODE_SKIP_VALIDATION = ForbiddenACHandlingModeSet.SKIP_VALIDATION.name();

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Validate CRX Content Packages";
        }

        public FormValidation doCheckValidationFilter(@QueryParameter String value) {
            try {
                WspFilter.parseSimpleSpec((String)value);
                return FormValidation.ok();
            }
            catch (RuntimeException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public ListBoxModel doFillForbiddenACHandlingModeSetItems() {
            ListBoxModel model = new ListBoxModel();
            for (ForbiddenACHandlingModeSet modeSet : ForbiddenACHandlingModeSet.values()) {
                model.add(modeSet.getListLabel(), modeSet.name());
            }
            return model;
        }
    }

    static class PackTuple {
        final PackId packId;
        final FilePath filePath;
        final boolean pathOnly;

        PackTuple(PackId packId, FilePath filePath) {
            this.packId = packId;
            this.filePath = filePath;
            this.pathOnly = this.packId == null;
        }

        public PackId getPackId() {
            return this.packId;
        }

        public FilePath getFilePath() {
            return this.filePath;
        }

        public boolean isPathOnly() {
            return this.pathOnly;
        }
    }
}

