/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import jenkins.MasterToSlaveFileCallable;
import net.adamcin.granite.client.packman.validation.DefaultValidationOptions;
import net.adamcin.granite.client.packman.validation.PackageValidator;
import net.adamcin.granite.client.packman.validation.ValidationOptions;
import net.adamcin.granite.client.packman.validation.ValidationResult;

public class ValidateFileCallable
extends MasterToSlaveFileCallable<Result> {
    final TaskListener listener;
    final DefaultValidationOptions options;

    public ValidateFileCallable(TaskListener listener, DefaultValidationOptions options) {
        this.listener = listener;
        this.options = options;
    }

    public Result invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        ValidationResult result = PackageValidator.validate((File)f, (ValidationOptions)this.options);
        if (result.getReason() == ValidationResult.Reason.SUCCESS) {
            return Result.SUCCESS;
        }
        switch (result.getReason()) {
            case ROOT_NOT_ALLOWED: {
                this.listener.fatalError("Package workspace filter defines a filter root which is not covered by the validation filter.");
                this.listener.error("Invalid filter set: %n%s", new Object[]{result.getInvalidRoot().toSpec()});
                break;
            }
            case ROOT_MISSING_RULES: {
                this.listener.fatalError("Package workspace filter defines a filter root which does not list the rules required by its covering validation filter.");
                this.listener.error("Invalid filter set: %n%s", new Object[]{result.getInvalidRoot().toSpec()});
                this.listener.error("Covered by validation filter set: %n%s", new Object[]{result.getCoveringRoot().toSpec()});
                break;
            }
            case FORBIDDEN_EXTENSION: {
                this.listener.fatalError("Package Archive contains an entry with a forbidden file extension.");
                this.listener.error("Invalid Jar entry: %s", new Object[]{result.getForbiddenEntry()});
                break;
            }
            case FORBIDDEN_ACHANDLING: {
                this.listener.fatalError("Package declares a forbidden AC Handling Mode.");
                this.listener.error("Forbidden AC Handling Mode: %s (%s)", new Object[]{result.getForbiddenACHandlingMode().getLabel(), result.getForbiddenACHandlingMode().getPropertyValue()});
                break;
            }
            case FORBIDDEN_FILTER_ROOT_PREFIX: {
                this.listener.fatalError("Package defines a path filter root with a forbidden prefix.");
                this.listener.error("Forbidden Filter Root Prefix: %s", new Object[]{result.getForbiddenEntry()});
                this.listener.error("Invalid filter set: %n%s", new Object[]{result.getInvalidRoot().toSpec()});
                break;
            }
            case DENIED_PATH_INCLUSION: {
                this.listener.fatalError("Package filter includes denied path.");
                this.listener.error("Path denied for inclusion: %s", new Object[]{result.getForbiddenEntry()});
                this.listener.error("Invalid filter set: %n%s", new Object[]{result.getInvalidRoot().toSpec()});
                break;
            }
            default: {
                this.listener.fatalError("Package validation of %s did not succeed because of %s", new Object[]{f.getAbsolutePath(), result.getReason().name()});
                if (result.getCause() == null) break;
                this.listener.error("Caused by %s", new Object[]{result.getCause()});
            }
        }
        return Result.FAILURE;
    }
}

