/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import net.adamcin.granite.client.packman.PackId;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.graniteclient.AbstractBuildStep;
import org.jenkinsci.plugins.graniteclient.BaseUrlUtil;
import org.jenkinsci.plugins.graniteclient.GraniteAHCFactory;
import org.jenkinsci.plugins.graniteclient.GraniteClientConfig;
import org.jenkinsci.plugins.graniteclient.GraniteClientExecutor;
import org.jenkinsci.plugins.graniteclient.GraniteCredentialsListBoxModel;
import org.jenkinsci.plugins.graniteclient.ReplicatePackagesClientCallable;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ReplicatePackagesBuilder
extends AbstractBuildStep {
    private String packageIds;
    private String baseUrls;
    private String credentialsId = null;
    private long requestTimeout = 0L;
    private long serviceTimeout = 0L;
    private long waitDelay = 0L;
    private boolean ignoreErrors = false;

    @DataBoundConstructor
    public ReplicatePackagesBuilder(String packageIds, String baseUrls) {
        this.packageIds = packageIds;
        this.baseUrls = baseUrls;
    }

    public ReplicatePackagesBuilder(String packageIds, String baseUrls, String credentialsId, long requestTimeout, long serviceTimeout, long waitDelay, boolean ignoreErrors) {
        this.packageIds = packageIds;
        this.baseUrls = baseUrls;
        this.credentialsId = credentialsId;
        this.requestTimeout = requestTimeout;
        this.serviceTimeout = serviceTimeout;
        this.waitDelay = waitDelay;
        this.ignoreErrors = ignoreErrors;
    }

    public void perform(@Nonnull Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        Result result = build.getResult();
        if (result == null) {
            result = Result.SUCCESS;
        }
        for (String baseUrl : this.listBaseUrls(build, workspace, listener)) {
            if (!result.isBetterOrEqualTo(Result.UNSTABLE)) continue;
            GraniteClientConfig clientConfig = new GraniteClientConfig(GraniteAHCFactory.getGlobalConfig(), baseUrl, this.credentialsId, this.requestTimeout, this.serviceTimeout, this.waitDelay);
            clientConfig.resolveCredentials();
            ReplicatePackagesClientCallable callable = new ReplicatePackagesClientCallable(listener, this.listPackIds(build, workspace, listener), this.ignoreErrors);
            try {
                result = result.combine(GraniteClientExecutor.execute(callable, clientConfig, listener));
            }
            catch (Exception e) {
                e.printStackTrace(listener.fatalError("Failed to replicate packages.", new Object[]{e.getMessage()}));
                if (this.ignoreErrors) {
                    result = result.combine(Result.UNSTABLE);
                    continue;
                }
                result = result.combine(Result.FAILURE);
            }
        }
        build.setResult(result);
    }

    public String getPackageIds() {
        if (this.packageIds != null) {
            return this.packageIds.trim();
        }
        return "";
    }

    public String getPackageIds(Run<?, ?> build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        try {
            return TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getPackageIds());
        }
        catch (MacroEvaluationException e) {
            listener.error("Failed to expand macros in Package ID: %s", new Object[]{this.getPackageIds()});
            return this.getPackageIds();
        }
    }

    public String getBaseUrls() {
        if (this.baseUrls != null) {
            return this.baseUrls.trim();
        }
        return "";
    }

    @DataBoundSetter
    public void setBaseUrls(String baseUrls) {
        this.baseUrls = baseUrls;
    }

    private List<String> listBaseUrls(Run<?, ?> build, FilePath workspace, TaskListener listener) {
        try {
            return BaseUrlUtil.splitByNewline(TokenMacro.expandAll(build, (FilePath)workspace, (TaskListener)listener, (String)this.getBaseUrls()));
        }
        catch (Exception e) {
            listener.error("failed to expand tokens in: %s%n", new Object[]{this.getBaseUrls()});
            return BaseUrlUtil.splitByNewline(this.getBaseUrls());
        }
    }

    public String getCredentialsId() {
        return this.credentialsId == null ? "" : this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = StringUtils.isBlank((String)credentialsId) ? null : credentialsId;
    }

    public List<PackId> listPackIds(Run<?, ?> build, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        ArrayList<PackId> packIds = new ArrayList<PackId>();
        for (String packageId : BaseUrlUtil.splitByNewline(this.getPackageIds(build, workspace, listener))) {
            PackId packId = PackId.parsePid((String)packageId);
            if (packId == null) continue;
            packIds.add(packId);
        }
        return Collections.unmodifiableList(packIds);
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public long getServiceTimeout() {
        return this.serviceTimeout;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    @DataBoundSetter
    public void setPackageIds(String packageIds) {
        this.packageIds = packageIds;
    }

    @DataBoundSetter
    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    @DataBoundSetter
    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    @DataBoundSetter
    public void setServiceTimeout(long serviceTimeout) {
        this.serviceTimeout = serviceTimeout;
    }

    public long getWaitDelay() {
        return this.waitDelay;
    }

    @DataBoundSetter
    public void setWaitDelay(long waitDelay) {
        this.waitDelay = waitDelay;
    }

    @Symbol(value={"crxReplicate"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public AbstractIdCredentialsListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter(value="baseUrls") String baseUrls, @QueryParameter(value="value") String value) {
            List<String> _baseUrls = BaseUrlUtil.splitByNewline(baseUrls);
            if (!_baseUrls.isEmpty()) {
                return GraniteCredentialsListBoxModel.fillItems(value, context, _baseUrls.iterator().next());
            }
            return GraniteCredentialsListBoxModel.fillItems(value, context);
        }

        public FormValidation doTestConnection(@QueryParameter(value="baseUrls") String baseUrls, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="requestTimeout") long requestTimeout, @QueryParameter(value="serviceTimeout") long serviceTimeout) throws IOException, ServletException {
            return BaseUrlUtil.testManyConnections(baseUrls, credentialsId, requestTimeout, serviceTimeout);
        }

        public String getDisplayName() {
            return "Replicate Content Packages from CRX";
        }
    }
}

