/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import hudson.FilePath;
import java.io.File;
import net.adamcin.granite.client.packman.PackId;
import net.adamcin.granite.client.packman.PackIdFilter;
import org.apache.jackrabbit.vault.util.PathUtil;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public final class PathOrPackIdFilter
implements PackIdFilter {
    public static final PathOrPackIdFilter INCLUDE_ALL_FILTER = new PathOrPackIdFilter("", null, null, null);
    public static final String WILDCARD = "*";
    private final String source;
    private final boolean pathFilter;
    private final String pathPattern;
    private final String group;
    private final String name;
    private final String version;

    public PathOrPackIdFilter(String source, String group, String name, String version) {
        this.source = source;
        this.pathFilter = false;
        this.pathPattern = null;
        this.group = group;
        this.name = name;
        this.version = version;
    }

    public PathOrPackIdFilter(String pathPattern) {
        this.source = pathPattern;
        this.pathFilter = true;
        this.pathPattern = pathPattern;
        this.group = null;
        this.name = null;
        this.version = null;
    }

    public boolean isPathFilter() {
        return this.pathFilter;
    }

    public String getPathPattern() {
        return this.pathPattern;
    }

    public String getSource() {
        return this.source;
    }

    public boolean includes(PackId packId) {
        if (this.isPathFilter()) {
            return SelectorUtils.matchPath((String)PathOrPackIdFilter.normalizeSlashes(this.pathPattern), (String)PathOrPackIdFilter.normalizeSlashes(packId.getInstallationPath() + ".zip")) || SelectorUtils.matchPath((String)PathOrPackIdFilter.normalizeSlashes(this.pathPattern), (String)PathOrPackIdFilter.normalizeSlashes(packId.getInstallationPath() + ".jar"));
        }
        boolean includes = true;
        if (this.group != null && this.group.length() > 0) {
            boolean bl = includes = includes && (this.group.equals(WILDCARD) || this.group.equals(packId.getGroup()));
        }
        if (this.name != null && this.name.length() > 0) {
            boolean bl = includes = includes && (this.name.equals(WILDCARD) || this.name.equals(packId.getName()));
        }
        if (this.version != null && this.version.length() > 0) {
            includes = includes && (this.version.equals(WILDCARD) || this.version.equals(packId.getVersion()));
        }
        return includes;
    }

    private static String normalizeSlashes(String path) {
        if (File.separatorChar == '\\') {
            return path.replace("/", "\\");
        }
        return path.replace("\\", "/");
    }

    public boolean includes(FilePath basePath, FilePath filePath) {
        if (this.isPathFilter()) {
            String relPath = PathUtil.getRelativeFilePath((String)PathOrPackIdFilter.normalizeSlashes(basePath.getRemote()), (String)PathOrPackIdFilter.normalizeSlashes(filePath.getRemote()));
            return SelectorUtils.matchPath((String)PathOrPackIdFilter.normalizeSlashes(this.pathPattern), (String)relPath);
        }
        return false;
    }

    public static PathOrPackIdFilter parse(String filterString) {
        if (filterString == null) {
            return INCLUDE_ALL_FILTER;
        }
        if (filterString.endsWith(".zip") || filterString.endsWith(".jar")) {
            return new PathOrPackIdFilter(filterString);
        }
        String[] parts = filterString.trim().split(":");
        switch (parts.length) {
            case 0: {
                return INCLUDE_ALL_FILTER;
            }
            case 1: {
                return new PathOrPackIdFilter(filterString, null, parts[0], null);
            }
            case 2: {
                return new PathOrPackIdFilter(filterString, parts[0], parts[1], null);
            }
        }
        return new PathOrPackIdFilter(filterString, parts[0], parts[1], parts[2]);
    }
}

