/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.graniteclient;

import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import net.adamcin.granite.client.packman.ListResponse;
import net.adamcin.granite.client.packman.ListResult;
import net.adamcin.granite.client.packman.PackId;
import net.adamcin.granite.client.packman.PackIdFilter;
import net.adamcin.granite.client.packman.PackageManagerClient;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.graniteclient.BaseUrlUtil;
import org.jenkinsci.plugins.graniteclient.GraniteAHCFactory;
import org.jenkinsci.plugins.graniteclient.GraniteClientConfig;
import org.jenkinsci.plugins.graniteclient.GraniteClientExecutor;
import org.jenkinsci.plugins.graniteclient.GraniteCredentialsListBoxModel;
import org.jenkinsci.plugins.graniteclient.PackageChoiceParameterValue;
import org.jenkinsci.plugins.graniteclient.PackageManagerClientCallable;
import org.jenkinsci.plugins.graniteclient.PathOrPackIdFilter;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class PackageChoiceParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = 2160382112619250912L;
    private String baseUrl;
    private String credentialsId;
    private long requestTimeout;
    private long serviceTimeout;
    private boolean multiselect;
    private long visibleItemCount;
    private boolean excludeNotInstalled;
    private boolean excludeModified;
    private String query;
    private String packageIdFilter;
    private String value;

    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        Object value = jo.get("value");
        if (value instanceof String) {
            return this.constructValue((String)value);
        }
        if (value instanceof JSONArray) {
            return this.constructValue((JSONArray)value);
        }
        return this.constructDefaultValue();
    }

    public ParameterValue createValue(StaplerRequest req) {
        String[] requestValues = req.getParameterValues(this.getName());
        if (requestValues == null || requestValues.length == 0) {
            return this.constructDefaultValue();
        }
        return this.constructValue(requestValues);
    }

    protected PackageChoiceParameterValue constructDefaultValue() {
        return new PackageChoiceParameterValue(this.getName(), "");
    }

    protected PackageChoiceParameterValue constructValue(String value) {
        return new PackageChoiceParameterValue(this.getName(), value);
    }

    protected PackageChoiceParameterValue constructValue(JSONArray values) {
        return this.constructValue(values.iterator());
    }

    protected PackageChoiceParameterValue constructValue(Iterator values) {
        return new PackageChoiceParameterValue(this.getName(), StringUtils.join((Iterator)values, (String)"\n"));
    }

    protected PackageChoiceParameterValue constructValue(String[] values) {
        return new PackageChoiceParameterValue(this.getName(), StringUtils.join((Object[])values, (String)"\n"));
    }

    public List<PackId> getPackageList() {
        GraniteClientConfig config = this.getGraniteClientConfig();
        try {
            config.resolveCredentials();
            ListResponse response = GraniteClientExecutor.execute(new Execution(this.query), config);
            ArrayList<PackId> packIds = new ArrayList<PackId>();
            List results = response.getResults();
            if (results != null) {
                for (ListResult result : results) {
                    if (this.excludeNotInstalled && !result.isHasSnapshot() || this.excludeModified && result.isNeedsRewrap() || !this.getPackIdFilter().includes(result.getPackId())) continue;
                    packIds.add(result.getPackId());
                }
            }
            return Collections.unmodifiableList(packIds);
        }
        catch (Exception e) {
            return this.getSelectedPackIds();
        }
    }

    public List<PackId> getSelectedPackIds() {
        ArrayList<PackId> packIds = new ArrayList<PackId>();
        String effectiveValue = this.getEffectiveValue();
        for (String pid : BaseUrlUtil.splitByNewline(effectiveValue)) {
            PackId packId = PackId.parsePid((String)pid);
            if (packId == null) continue;
            packIds.add(packId);
        }
        return Collections.unmodifiableList(packIds);
    }

    @DataBoundConstructor
    public PackageChoiceParameterDefinition(String name, String description, String baseUrl, String credentialsId, long requestTimeout, long serviceTimeout, boolean multiselect, boolean excludeNotInstalled, boolean excludeModified, long visibleItemCount, String query, String packageIdFilter, String value) {
        super(name, description);
        this.baseUrl = baseUrl;
        this.credentialsId = credentialsId;
        this.requestTimeout = requestTimeout;
        this.serviceTimeout = serviceTimeout;
        this.multiselect = multiselect;
        this.visibleItemCount = visibleItemCount;
        this.excludeNotInstalled = excludeNotInstalled;
        this.excludeModified = excludeModified;
        this.query = query;
        this.packageIdFilter = packageIdFilter;
        this.value = value;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public long getServiceTimeout() {
        return this.serviceTimeout;
    }

    public void setServiceTimeout(long serviceTimeout) {
        this.serviceTimeout = serviceTimeout;
    }

    public boolean isMultiselect() {
        return this.multiselect;
    }

    public void setMultiselect(boolean multiselect) {
        this.multiselect = multiselect;
    }

    public long getVisibleItemCount() {
        if (this.visibleItemCount <= 0L) {
            return 10L;
        }
        return this.visibleItemCount;
    }

    public void setVisibleItemCount(long visibleItemCount) {
        this.visibleItemCount = visibleItemCount;
    }

    public boolean isExcludeNotInstalled() {
        return this.excludeNotInstalled;
    }

    public void setExcludeNotInstalled(boolean excludeNotInstalled) {
        this.excludeNotInstalled = excludeNotInstalled;
    }

    public boolean isExcludeModified() {
        return this.excludeModified;
    }

    public void setExcludeModified(boolean excludeModified) {
        this.excludeModified = excludeModified;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getPackageIdFilter() {
        return this.packageIdFilter;
    }

    public void setPackageIdFilter(String packageIdFilter) {
        this.packageIdFilter = packageIdFilter;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getEffectiveValue() {
        if (this.value == null) {
            return "";
        }
        return this.value.trim();
    }

    public PackIdFilter getPackIdFilter() {
        return PathOrPackIdFilter.parse(this.getPackageIdFilter());
    }

    public GraniteClientConfig getGraniteClientConfig() {
        return new GraniteClientConfig(GraniteAHCFactory.getGlobalConfig(), this.getBaseUrl(), this.getCredentialsId(), this.requestTimeout, this.serviceTimeout);
    }

    private static class Execution
    implements PackageManagerClientCallable<ListResponse> {
        private final String query;

        public Execution(String query) {
            this.query = query;
        }

        @Override
        public ListResponse doExecute(PackageManagerClient client) throws Exception {
            return client.list(this.query);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "CRX Content Package Choice Parameter";
        }

        public FormValidation doTestConnection(@QueryParameter(value="baseUrl") String baseUrl, @QueryParameter(value="credentialsId") String credentialsId, @QueryParameter(value="requestTimeout") long requestTimeout, @QueryParameter(value="serviceTimeout") long serviceTimeout) throws IOException, ServletException {
            return BaseUrlUtil.testOneConnection(baseUrl, credentialsId, requestTimeout, serviceTimeout);
        }

        public AbstractIdCredentialsListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter(value="baseUrl") String baseUrl, @QueryParameter(value="value") String value) {
            return GraniteCredentialsListBoxModel.fillItems(value, context, baseUrl);
        }
    }
}

